-- Create new columns for published state
ALTER TABLE workstream_entry
ADD (
  published CHAR(1 CHAR),
  published_at TIMESTAMP
);

-- Migrate all previous workstream_entry rows to be published on their created_at date
UPDATE workstream_entry SET published_at = created_at;
UPDATE workstream_entry SET published = 't';

ALTER TABLE workstream_entry MODIFY published NOT NULL;

-- Repeat for shadow table

ALTER TABLE sh_workstream_entry
ADD (
  published CHAR(1 CHAR),
  published_at TIMESTAMP
);

UPDATE sh_workstream_entry SET published_at = created_at;
UPDATE sh_workstream_entry SET published = 't';

ALTER TABLE sh_workstream_entry MODIFY published NOT NULL;

COMMIT;
