-- disable refresh token ability for mobile, but keep access token validity with 30 days for now
UPDATE oauth_client_details
SET    access_token_validity  = 30 * 24 * 60 * 60,
       refresh_token_validity = null,
       authorized_grant_types = 'implicit,password,authorization_code,client_credentials'
WHERE  client_id = 'mobile';

-- insert client with 1 hour access token time and 30 days refresh token validity
INSERT INTO oauth_client_details (
    client_id,
    scope,
    authorized_grant_types,
    authorities,
    access_token_validity,
    refresh_token_validity
) VALUES (
    'app',
    'api',
    'implicit,password,authorization_code,client_credentials,refresh_token',
    'ROLE_USER',
    1 * 60 * 60,
    30 * 24 * 60 * 60
);

COMMIT;
