-- create table oauth_token
CREATE TABLE oauth_token (
    access_token VARCHAR2(256 char) NOT NULL,
    access_token_expiry TIMESTAMP NOT NULL,
    refresh_token VARCHAR2(256 char),
    refresh_token_expiry TIMESTAMP,
    client_id VARCHAR2(256 char) NOT NULL,
    scope VARCHAR2(256 char) NOT NULL,
    grant_type VARCHAR2(256 char) NOT NULL,
    person_id NUMBER(19,0),
    create_date TIMESTAMP DEFAULT systimestamp NOT NULL,
    CONSTRAINT o_t_access_token_pk PRIMARY KEY (access_token),
    CONSTRAINT o_t_person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE,
    CONSTRAINT o_t_client_fk FOREIGN KEY (client_id) REFERENCES oauth_client_details (client_id) ON DELETE CASCADE
);

-- add indice for common selects within the JdbcTokenStore
CREATE INDEX idx_oauth_token_refresh ON oauth_token (refresh_token);
CREATE INDEX idx_oauth_token_user    ON oauth_token (person_id);
CREATE INDEX idx_oauth_token_client  ON oauth_token (client_id);

COMMIT;
