CREATE SEQUENCE juco_version_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE juco_version (
    id number(19) NOT NULL,
    version varchar2(256 char) NOT NULL,
    create_at timestamp DEFAULT systimestamp,
    CONSTRAINT juco_version_pk PRIMARY KEY (id)
);

CREATE TABLE juco_version_update_process (
    version_id NUMBER(19) NOT NULL,
    process varchar2(100 char) NOT NULL,
    status varchar2(50 char) NOT NULL,
    create_at timestamp DEFAULT systimestamp,
    modify_at timestamp DEFAULT systimestamp,
   CONSTRAINT j_v_u_p_pkey PRIMARY KEY(version_id, process),
   CONSTRAINT j_v_u_p_j_version_fk FOREIGN KEY (version_id) REFERENCES juco_version(id) ON DELETE CASCADE
);

COMMIT;
