
CREATE SEQUENCE conversation_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;
    
CREATE SEQUENCE conversation_message_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;
    
CREATE TABLE conversation (
    id number(19) NOT NULL,
    type VARCHAR2(255 char) NOT NULL, 
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT conversation_pk PRIMARY KEY (id)
);

CREATE TABLE conversation_participant (
    conversation_id number(19) NOT NULL,
    participant_id number(19) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp NOT NULL,
    unread_count number(19) DEFAULT 0 NOT NULL,
    CONSTRAINT conv_participant_pk UNIQUE (conversation_id, participant_id),
    CONSTRAINT conv_participant_conv_fk FOREIGN KEY (conversation_id) REFERENCES conversation(id) ON DELETE CASCADE,
    CONSTRAINT conv_participant_part_fk FOREIGN KEY (participant_id) REFERENCES person(id) ON DELETE CASCADE
);

CREATE TABLE conversation_message (
    id number(19) NOT NULL,
    conversation_id number(19) NOT NULL,
    from_person_id number(19) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    message CLOB NOT NULL,
    CONSTRAINT conv_message_pk PRIMARY KEY (id),
    CONSTRAINT conv_message_pers_fk FOREIGN KEY (from_person_id) REFERENCES person(id) ON DELETE CASCADE,
    CONSTRAINT conv_message_conv_fk FOREIGN KEY (conversation_id) REFERENCES conversation(id) ON DELETE CASCADE
);

CREATE INDEX idx_conversation_type ON conversation(type);

COMMIT;