-- drop constraints and indexes
ALTER TABLE person DROP CONSTRAINT person_pseudonym_uk;
DROP INDEX idx_person__pseudonym;

-- remove pseudoym from person
ALTER TABLE person DROP (pseudonym, pseudonym_enabled);

--update person shadow table
ALTER TABLE sh_person DROP (pseudonym, pseudonym_enabled);

-- remove domain i18n properties
DELETE FROM domain_property
WHERE base_property IN
    (SELECT id FROM base_property
     WHERE container_name = 'messages'
     AND property_name IN ('Exception/Constants/pseudonymAlreadyExists',
                           'Profile/Constants/pseudonym',
                           'Profile/Constants/pseudonymDisplayText'
                          )
    );

-- remove base i18n properties
DELETE FROM base_property
WHERE container_name = 'messages'
 AND property_name IN ('Exception/Constants/pseudonymAlreadyExists',
                       'Profile/Constants/pseudonym',
                       'Profile/Constants/pseudonymDisplayText'
                      );

-- remove setting from superoperty
DELETE FROM base_property WHERE property_name = 'Settings/profile/pseudonymEnabled' AND container_name='systemSettings';

COMMIT;

