INSERT INTO version (id, release, name, type, description, "date")
VALUES (00003, '8.0', '00002_#patch_menu_links', 'FEATURE', '#8839 Linkes Menü: Alle Links frei über die Konfiguration wählbar machen', now());

-- create old properties if they not yet exist to get merge working
INSERT INTO base_property (id, property_name, converter_class, default_value, inheritance_type, container_name, last_changed, description)
SELECT seq_base_property.nextval, 'Settings/Menu/menu links 1', '', '' , 'F', 'systemSettings', now(), '...'
    FROM dual WHERE NOT EXISTS (SELECT 1 FROM base_property WHERE property_name='Settings/Menu/menu links 1' AND container_name = 'systemSettings');
INSERT INTO base_property (id, property_name, converter_class, default_value, inheritance_type, container_name, last_changed, description)
SELECT seq_base_property.nextval, 'Settings/Menu/menu links 2', '', '' , 'F', 'systemSettings', now(), '...'
    FROM dual WHERE NOT EXISTS (SELECT 1 FROM base_property WHERE property_name='Settings/Menu/menu links 2' AND container_name = 'systemSettings');

-- delete possible target property if it already exists, so the insert statement can run --
DELETE FROM base_property WHERE property_name = 'Settings/Menu/menu links' AND container_name = 'systemSettings';

-- insert the new menu links property
INSERT INTO base_property (id, property_name, converter_class, default_value, inheritance_type, container_name, last_changed, description)
SELECT  seq_base_property.nextval, 'Settings/Menu/menu links', 'com.freiheit.superoperty.container.MenulinksConverter',
        (SELECT default_value FROM base_property WHERE property_name = 'Settings/Menu/menu links 1') || ',' || (SELECT default_value FROM base_property WHERE property_name = 'Settings/Menu/menu links 2'), 
        'F', 'systemSettings', now(), '...'
    FROM dual;

-- delete deprecated properties
DELETE FROM base_property WHERE property_name IN ('Settings/Menu/menu links 1','Settings/Menu/menu links 2' , 'Settings/Menu/additional link url', 'Settings/Menu/additional link url 2', 'Settings/Menu/''my contents'' teaser types' ) AND container_name = 'systemSettings';

COMMIT;
