INSERT INTO version (
  id, release, name, type, description, "date"
) VALUES (
  01314, '6.13', '01314_6.13_create_multiwiki_tables.sql', 'FEATURE', '#4453 Basis des Mehrfacheditoren-Moduls', now()
);

CREATE SEQUENCE multi_wiki_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE multi_wiki (
    id number(19) NOT NULL,
    parent_item_id number(19) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT multi_wiki_pk PRIMARY KEY (id),
    CONSTRAINT multi_wiki_parent_unq UNIQUE (parent_item_id, parent_item_type)
);

CREATE SEQUENCE multi_wiki_version_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE multi_wiki_version (
    id number(19) NOT NULL,
    wiki_id number(19) NOT NULL REFERENCES multi_wiki(id) ON DELETE CASCADE,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT multi_wiki_version_pk PRIMARY KEY (id)
);

CREATE SEQUENCE multi_wiki_section_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE multi_wiki_section (
    id number(19) NOT NULL,
    version_id number(19) NOT NULL REFERENCES multi_wiki_version(id) ON DELETE CASCADE,
    headline VARCHAR2(256 CHAR) NOT NULL,
    html CLOB NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT multi_wiki_section_pk PRIMARY KEY (id)
);

COMMIT;
