-- Copies the existing entity specific messages into the new structure. ---
-- Old keys/values will not be removed as we need the old keys for older versions of just connect ---

INSERT INTO version (id, release, name, type, description, "date") VALUES (01302, '6.12', 'migrate-entity-search-filter-labels.sql', 'FEATURE', 'remove harcoded entity-type specific messages for search filters', sysdate);

-- creates a copy of a base_property with the id 'origin_property_id' with a new name 'new_base_property_name'
-- CREATE OR REPLACE FUNCTION COPY_BASE_PROPERTY (origin_property_id BIGINT, new_base_property_name varchar) RETURNS BIGINT AS
-- $$
-- DECLARE
--     new_property_id BIGINT;
--     origin base_property%ROWTYPE;
-- BEGIN
--     SELECT seq_base_property.nextval INTO new_property_id;

--     SELECT * INTO origin FROM base_property WHERE id=origin_property_id;

--     INSERT INTO base_property (id, property_name, converter_class, description, default_value, container_name, create_at, last_changed, inheritance_type)
--         VALUES(new_property_id, new_base_property_name,
--         origin.converter_class, origin.description,
--         origin.default_value, origin.container_name, origin.create_at, origin.last_changed, origin.inheritance_type);
--     RETURN new_property_id;
-- END;
-- $$ LANGUAGE plpgsql;

-- copies a domain_property and assigns the copy to given base_property
-- CREATE OR REPLACE FUNCTION COPY_DOMAIN_PROPERTY (origin_domain_property_id BIGINT, new_base_property_id BIGINT) RETURNS BIGINT AS
-- $$
-- DECLARE
--     new_property_id BIGINT;
--     origin domain_property%ROWTYPE;
-- BEGIN
--     SELECT seq_domain_property.nextval INTO new_property_id;

--     SELECT * INTO origin FROM domain_property WHERE id=origin_domain_property_id;
--     INSERT INTO domain_property (id, base_property, domain, overridden_value, last_changed, change_user, create_at)
--         VALUES(new_property_id, new_base_property_id,
--         origin.domain, origin.overridden_value, origin.last_changed,
--         origin.change_user, origin.create_at);
--     RETURN new_property_id;
-- END;
-- $$ LANGUAGE plpgsql;

-- copies the property and its belonging domain_properties identified by its property_name
-- CREATE OR REPLACE FUNCTION COPY_TRANSLATION (old_base_property_name varchar, new_base_property_name varchar) RETURNS VOID AS
-- $$
-- DECLARE
--     new_base_id BIGINT;
--     old_base_id BIGINT;
--     domain_prop domain_property%ROWTYPE;

-- BEGIN
--     SELECT id INTO old_base_id from base_property where property_name=old_base_property_name;
--     IF old_base_id IS NOT NULL THEN    
        
--         SELECT id INTO new_base_id id from base_property where property_name=new_base_property_name;
--         --if new_base_id is null, create a copy of the old record ---
--         IF new_base_id IS NULL THEN
--             SELECT COPY_BASE_PROPERTY(old_base_id, new_base_property_name) INTO new_base_id;
--             RAISE NOTICE 'copied % into new base_property - new_base_id %', old_base_id, new_base_id;
--         END IF;

--         -- Update the base property --
--         UPDATE base_property set default_value=(SELECT default_value FROM base_property WHERE id=old_base_id) WHERE id=new_base_id;

--         --update the domain_property values
--         FOR domain_prop IN SELECT * FROM domain_property WHERE base_property=old_base_id LOOP
--             RAISE NOTICE 'new domain_property % - new_base_id %', domain_prop.id, new_base_id;
--             PERFORM COPY_DOMAIN_PROPERTY(domain_prop.id, new_base_id);
--         END LOOP;
--     
--     END IF;
-- END;
-- $$ LANGUAGE plpgsql;

-- Actual migration ---


-- Newsletter-Translations --
-- Network --
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelNetwork','Entity/Messages/filterTypeLabelSingular/Network');
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelNetworks','Entity/Messages/filterTypeLabelPlural/Network');

-- Appointment --
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelAppointment','Entity/Messages/filterTypeLabelSingular/Appointment');
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelAppointments','Entity/Messages/filterTypeLabelPlural/Appointment');

-- Group --
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelGroup','Entity/Messages/filterTypeLabelSingular/Group');
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelGroups','Entity/Messages/filterTypeLabelPlural/Group');

-- Topic --
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelTopic','Entity/Messages/filterTypeLabelSingular/Topic');
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelTopics','Entity/Messages/filterTypeLabelPlural/Topic');

-- Partnersite --
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelPartnersite','Entity/Messages/filterTypeLabelSingular/PartnerSite');
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelPartnersites','Entity/Messages/filterTypeLabelPlural/PartnerSite');

-- Article --
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelArticle','Entity/Messages/filterTypeLabelSingular/Article');
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelArticles','Entity/Messages/filterTypeLabelPlural/Article');

-- Publication --
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelPublication','Entity/Messages/filterTypeLabelSingular/Publication');
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelPublications','Entity/Messages/filterTypeLabelPlural/Publication');

-- Wiki --
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelWiki','Entity/Messages/filterTypeLabelSingular/Wiki');
-- SELECT COPY_TRANSLATION('Search/Constants/filterTypeLabelWikis','Entity/Messages/filterTypeLabelPlural/Wiki');


-- DROP FUNCTION COPY_BASE_PROPERTY (origin_property_id BIGINT, new_base_property_name varchar);
-- DROP FUNCTION COPY_DOMAIN_PROPERTY (origin_domain_property_id BIGINT, new_base_property_id BIGINT);
-- DROP FUNCTION COPY_TRANSLATION (old_base_property_name varchar, new_base_property_name varchar);

COMMIT;
