-- Copies the existing entity specific messages into the new structure. ---
-- Old keys/values will not be removed as we need the old keys for older versions of just connect ---

INSERT INTO version (id, release, name, type, description, "date") VALUES (01300, '6.12', 'remove harcoded entity type messages', 'FEATURE', 'remove harcoded entity-type specific messages and config and move them into dynamic entityType messages', sysdate);

-- creates a copy of a base_property with the id 'origin_property_id' with a new name 'new_base_property_name'
-- CREATE OR REPLACE FUNCTION COPY_BASE_PROPERTY (origin_property_id BIGINT, new_base_property_name varchar) RETURNS BIGINT AS
-- $$
-- DECLARE
--     new_property_id BIGINT;
--     origin base_property%ROWTYPE;
-- BEGIN
--     SELECT seq_base_property.nextval INTO new_property_id;

--     SELECT * INTO origin FROM base_property WHERE id=origin_property_id;

--     INSERT INTO base_property (id, property_name, converter_class, description, default_value, container_name, create_at, last_changed, inheritance_type)
--         VALUES(new_property_id, new_base_property_name,
--         origin.converter_class, origin.description,
--         origin.default_value, origin.container_name, origin.create_at, origin.last_changed, origin.inheritance_type);
--     RETURN new_property_id;
-- END;
-- $$ LANGUAGE plpgsql;

-- copies a domain_property and assigns the copy to given base_property
-- CREATE OR REPLACE FUNCTION COPY_DOMAIN_PROPERTY (origin_domain_property_id BIGINT, new_base_property_id BIGINT) RETURNS BIGINT AS
-- $$
-- DECLARE
--     new_property_id BIGINT;
--     origin domain_property%ROWTYPE;
-- BEGIN
--     SELECT seq_domain_property.nextval INTO new_property_id;

--     SELECT * INTO origin FROM domain_property WHERE id=origin_domain_property_id;
--     INSERT INTO domain_property (id, base_property, domain, overridden_value, last_changed, change_user, create_at)
--         VALUES(new_property_id, new_base_property_id,
--         origin.domain, origin.overridden_value, origin.last_changed,
--         origin.change_user, origin.create_at);
--     RETURN new_property_id;
-- END;
-- $$ LANGUAGE plpgsql;

-- copies the property and its belonging domain_properties identified by its property_name
-- CREATE OR REPLACE FUNCTION COPY_TRANSLATION (old_base_property_name varchar, new_base_property_name varchar) RETURNS VOID AS
-- $$
-- DECLARE
--     new_base_id BIGINT;
--     old_base_id BIGINT;
--     domain_prop domain_property%ROWTYPE;

-- BEGIN
--     SELECT id INTO old_base_id from base_property where property_name=old_base_property_name;
--     IF old_base_id IS NOT NULL THEN      
--         SELECT id INTO new_base_id id from base_property where property_name=new_base_property_name;
--         --if new_base_id is null, create a copy of the old record ---
--         IF new_base_id IS NULL THEN
--             SELECT COPY_BASE_PROPERTY(old_base_id, new_base_property_name) INTO new_base_id;
--             RAISE NOTICE 'copied % into new base_property - new_base_id %', old_base_id, new_base_id;
--         END IF;

--         -- Update the base property --
--         UPDATE base_property set default_value=(SELECT default_value FROM base_property WHERE id=old_base_id) WHERE id=new_base_id;

--         --update the domain_property values
--         FOR domain_prop IN SELECT * FROM domain_property WHERE base_property=old_base_id LOOP
--             RAISE NOTICE 'new domain_property % - new_base_id %', domain_prop.id, new_base_id;
--             PERFORM COPY_DOMAIN_PROPERTY(domain_prop.id, new_base_id);
--         END LOOP;

--     END IF;
-- END;
-- $$ LANGUAGE plpgsql;

-- Actual migration ---

-- Special weltbeweger translation --
-- SELECT COPY_TRANSLATION('Wiki/Constants/createYourOwnWay','Entity/Constants/createOwnEntity/Wiki');

-- Newsletter-Translations --
-- Network --
-- SELECT COPY_TRANSLATION('Newsletter/Messages/newNetwork','Newsletter/Messages/Entites/Network/newEntity');
-- SELECT COPY_TRANSLATION('Newsletter/Messages/xJoinedTheNetworkY','Newsletter/Messages/Entites/Network/xJoinedY');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/newNetwork','NewsletterHtml/Messages/Entites/Network/newEntity');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/networkJoined','NewsletterHtml/Messages/Entites/Network/xJoinedY');

-- Appointment --
-- SELECT COPY_TRANSLATION('Newsletter/Messages/newAppointment','Newsletter/Messages/Entites/Appointment/newEntity');
-- SELECT COPY_TRANSLATION('Newsletter/Messages/xJoinedTheAppointmentY','Newsletter/Messages/Entites/Appointment/xJoinedY');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/newAppointment','NewsletterHtml/Messages/Entites/Appointment/newEntity');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/appointmentJoined','NewsletterHtml/Messages/Entites/Appointment/xJoinedY');

-- Group --
-- SELECT COPY_TRANSLATION('Newsletter/Messages/newGroup','Newsletter/Messages/Entites/Group/newEntity');
-- SELECT COPY_TRANSLATION('Newsletter/Messages/xJoinedTheGroupY','Newsletter/Messages/Entites/Group/xJoinedY');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/newGroup','NewsletterHtml/Messages/Entites/Group/newEntity');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/groupJoined','NewsletterHtml/Messages/Entites/Group/xJoinedY');

-- Topic --
-- SELECT COPY_TRANSLATION('Newsletter/Messages/newTopic','Newsletter/Messages/Entites/Topic/newEntity');
-- SELECT COPY_TRANSLATION('Newsletter/Messages/xJoinedTheTopicY','Newsletter/Messages/Entites/Topic/xJoinedY');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/newTopic','NewsletterHtml/Messages/Entites/Topic/newEntity');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/topicJoined','NewsletterHtml/Messages/Entites/Topic/xJoinedY');

-- Partnersite --
-- SELECT COPY_TRANSLATION('Newsletter/Messages/newPartnersite','Newsletter/Messages/Entites/Partnersite/newEntity');
-- SELECT COPY_TRANSLATION('Newsletter/Messages/xJoinedThePartnersiteY','Newsletter/Messages/Entites/Partnersite/xJoinedY');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/newPartnersite','NewsletterHtml/Messages/Entites/Partnersite/newEntity');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/partnersiteJoined','NewsletterHtml/Messages/Entites/Partnersite/xJoinedY');

-- Article --
-- SELECT COPY_TRANSLATION('Newsletter/Messages/newArticle','Newsletter/Messages/Entites/Article/newEntity');
-- SELECT COPY_TRANSLATION('Newsletter/Messages/xJoinedTheArticleY','Newsletter/Messages/Entites/Article/xJoinedY');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/newArticle','NewsletterHtml/Messages/Entites/Article/newEntity');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/articleJoined','NewsletterHtml/Messages/Entites/Article/xJoinedY');

-- Publication --
-- SELECT COPY_TRANSLATION('Newsletter/Messages/newPublication','Newsletter/Messages/Entites/Publication/newEntity');
-- SELECT COPY_TRANSLATION('Newsletter/Messages/xJoinedThePublicationY','Newsletter/Messages/Entites/Publication/xJoinedY');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/newPublication','NewsletterHtml/Messages/Entites/Publication/newEntity');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/publicationJoined','NewsletterHtml/Messages/Entites/Publication/xJoinedY');

-- Wiki --
-- SELECT COPY_TRANSLATION('Newsletter/Messages/newWikiPage','Newsletter/Messages/Entites/Wiki/newEntity');
-- SELECT COPY_TRANSLATION('Newsletter/Messages/xJoinedTheWikiY','Newsletter/Messages/Entites/Wiki/xJoinedY');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/newWikiPage','NewsletterHtml/Messages/Entites/Wiki/newEntity');
-- SELECT COPY_TRANSLATION('NewsletterHtml/Messages/wikiJoined','NewsletterHtml/Messages/Entites/Wiki/xJoinedY');


-- DROP FUNCTION COPY_BASE_PROPERTY (origin_property_id BIGINT, new_base_property_name varchar);
-- DROP FUNCTION COPY_DOMAIN_PROPERTY (origin_domain_property_id BIGINT, new_base_property_id BIGINT);
-- DROP FUNCTION COPY_TRANSLATION (old_base_property_name varchar, new_base_property_name varchar);

COMMIT;
