
INSERT INTO version (id, release, name, type, description, "date") VALUES (01299, '6.12', 'migrate-component-type', 'FEATURE', 'child entities component types have parameter now', sysdate);

CREATE TABLE temp_component_type (
    old_name VARCHAR(255) NOT NULL PRIMARY KEY,
    new_name VARCHAR(255) NOT NULL
);

INSERT ALL
    INTO temp_component_type(old_name, new_name) VALUES ('CHILD_APPOINTMENTS', 'CHILD_ENTITIES#APPOINTMENT')
    INTO temp_component_type(old_name, new_name) VALUES ('CHILD_GROUPS', 'CHILD_ENTITIES#GROUP')
    INTO temp_component_type(old_name, new_name) VALUES ('CHILD_NETWORKS', 'CHILD_ENTITIES#NETWORK')
    INTO temp_component_type(old_name, new_name) VALUES ('CHILD_PUBLICATIONS', 'CHILD_ENTITIES#PUBLICATION')
    INTO temp_component_type(old_name, new_name) VALUES ('CHILD_WIKIS', 'CHILD_ENTITIES#WIKI')
    INTO temp_component_type(old_name, new_name) VALUES ('CHILD_TOPICS', 'CHILD_ENTITIES#TOPIC')
    INTO temp_component_type(old_name, new_name) VALUES ('CHILD_ARTICLES', 'CHILD_ENTITIES#ARTICLE')
    INTO temp_component_type(old_name, new_name) VALUES ('CHILD_PARTNERSITES', 'CHILD_ENTITIES#PARTNERSITE')

SELECT * FROM dual;

ALTER TABLE entity_component MODIFY (component_type VARCHAR2(255));
UPDATE entity_component
    SET component_type = (SELECT new_name FROM temp_component_type WHERE old_name = component_type)
    WHERE component_type IN (SELECT old_name FROM temp_component_type);

ALTER TABLE entity_component_open_for MODIFY (component_type VARCHAR2(255));
UPDATE entity_component_open_for
    SET component_type = (SELECT new_name FROM temp_component_type
    WHERE old_name = component_type) WHERE component_type IN (SELECT old_name FROM temp_component_type);

ALTER TABLE profile_component MODIFY (component_type VARCHAR2(255));
UPDATE profile_component 
    SET component_type = (SELECT new_name FROM temp_component_type WHERE old_name = component_type)
    WHERE component_type IN (SELECT old_name FROM temp_component_type);

ALTER TABLE profile_component_visibility MODIFY (component_type VARCHAR2(255));
UPDATE profile_component_visibility
    SET component_type = (SELECT new_name FROM temp_component_type WHERE old_name = component_type)
    WHERE component_type IN (SELECT old_name FROM temp_component_type);

ALTER TABLE raweditor_version MODIFY (editor_type VARCHAR2(255));
UPDATE raweditor_version
    SET editor_type = (SELECT new_name FROM temp_component_type WHERE old_name = editor_type)
    WHERE editor_type IN (SELECT old_name FROM temp_component_type);

DROP TABLE temp_component_type;

COMMIT;
