/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.runner.impl;

import java.io.File;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.script.runner.impl.Application;
import org.dbmaintain.script.runner.impl.BaseNativeScriptRunner;
import org.dbmaintain.util.DbMaintainException;

public class PSQLScriptRunner
extends BaseNativeScriptRunner {
    protected final Application _application;
    private static final String SCRIPT_RUNNER_NAME = "psql";
    private static final String DEFAULT_DB_PORT = "5432";

    public PSQLScriptRunner(Databases databases, String cmd) {
        super(databases);
        this._application = new Application(SCRIPT_RUNNER_NAME, cmd);
    }

    protected void executeScript(File scriptFile, Database targetDatabase) throws Exception {
        String port;
        String[] url_parts = targetDatabase.getDatabaseInfo().getUrl().split("/");
        String databaseName = url_parts[3];
        String[] host_port = url_parts[2].split(":");
        String host = host_port[0];
        String[] arguments = new String[]{"-h", host, "-p", port = host_port.length > 1 ? host_port[1] : DEFAULT_DB_PORT, "-U", targetDatabase.getDatabaseInfo().getUserName(), "-d", databaseName, "-f", scriptFile.getAbsolutePath(), "-v", "ON_ERROR_STOP=1"};
        Application.ProcessOutput processOutput = this._application.execute(arguments);
        int exitValue = processOutput.getExitValue();
        if (exitValue != 0 || processOutput.getOutput().toLowerCase().contains("rollback") || processOutput.getOutput().toLowerCase().contains("error")) {
            throw new DbMaintainException("Failed to execute command:\n" + processOutput.getOutput());
        }
    }
}

