/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.structure.model;

import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.database.StoredIdentifierCase;
import org.dbmaintain.structure.model.DbItemType;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.lang.StringUtils;

public class DbItemIdentifier {
    private DbItemType type;
    private String databaseName;
    private String schemaName;
    private String itemName;
    private boolean dbMaintainIdentifier;

    private DbItemIdentifier(DbItemType type, String databaseName, String schemaName, String itemName, boolean dbMaintainIdentifier) {
        this.type = type;
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.itemName = itemName;
        this.dbMaintainIdentifier = dbMaintainIdentifier;
    }

    public DbItemType getType() {
        return this.type;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public DbItemIdentifier getSchema() {
        return new DbItemIdentifier(DbItemType.SCHEMA, this.databaseName, this.schemaName, null, false);
    }

    public boolean isDbMaintainIdentifier() {
        return this.dbMaintainIdentifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = 31 * result + (this.itemName == null ? 0 : this.itemName.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbItemIdentifier other = (DbItemIdentifier)obj;
        if (this.databaseName == null ? other.databaseName != null : !this.databaseName.equals(other.databaseName)) {
            return false;
        }
        if (this.itemName == null ? other.itemName != null : !this.itemName.equals(other.itemName)) {
            return false;
        }
        return !(this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName));
    }

    public static DbItemIdentifier parseItemIdentifier(DbItemType type, String identifierAsString, Databases databases) {
        String itemName;
        String schemaName;
        Database database;
        String[] identifierParts = StringUtils.split(identifierAsString, '.');
        if (identifierParts.length == 3) {
            String databaseName = identifierParts[0];
            database = databases.getDatabase(databaseName);
            if (database == null) {
                return null;
            }
            schemaName = identifierParts[1];
            itemName = identifierParts[2];
        } else if (identifierParts.length == 2) {
            database = databases.getDefaultDatabase();
            schemaName = identifierParts[0];
            itemName = identifierParts[1];
        } else if (identifierParts.length == 1) {
            database = databases.getDefaultDatabase();
            schemaName = database.getDefaultSchemaName();
            itemName = identifierParts[0];
        } else {
            throw new DbMaintainException("Incorrectly formatted db item identifier " + identifierAsString);
        }
        String correctCaseSchemaName = database.toCorrectCaseIdentifier(schemaName);
        String correctCaseItemName = database.toCorrectCaseIdentifier(itemName);
        return DbItemIdentifier.getItemIdentifier(type, correctCaseSchemaName, correctCaseItemName, database);
    }

    public static DbItemIdentifier parseSchemaIdentifier(String identifierAsString, Databases databases) {
        String schemaName;
        Database database;
        String[] identifierParts = StringUtils.split(identifierAsString, '.');
        if (identifierParts.length == 2) {
            String databaseName = identifierParts[0];
            database = databases.getDatabase(databaseName);
            if (database == null) {
                return null;
            }
            schemaName = identifierParts[1];
        } else if (identifierParts.length == 1) {
            database = databases.getDefaultDatabase();
            schemaName = identifierParts[0];
        } else {
            throw new DbMaintainException("Incorrectly formatted db schema identifier " + identifierAsString);
        }
        return DbItemIdentifier.getItemIdentifier(DbItemType.SCHEMA, schemaName, null, database);
    }

    public static DbItemIdentifier getSchemaIdentifier(String schemaName, Database database) {
        return DbItemIdentifier.getItemIdentifier(DbItemType.SCHEMA, schemaName, null, database, false);
    }

    public static DbItemIdentifier getItemIdentifier(DbItemType type, String schemaName, String itemName, Database database) {
        return DbItemIdentifier.getItemIdentifier(type, schemaName, itemName, database, false);
    }

    public static DbItemIdentifier getItemIdentifier(DbItemType type, String schemaName, String itemName, Database database, boolean dbMaintainIdentifier) {
        if (database.getStoredIdentifierCase() == StoredIdentifierCase.MIXED_CASE) {
            if (!database.isQuoted(schemaName)) {
                schemaName = schemaName.toUpperCase();
            }
            if (itemName != null && !database.isQuoted(itemName)) {
                itemName = itemName.toUpperCase();
            }
        }
        String correctCaseSchemaName = database.toCorrectCaseIdentifier(schemaName);
        String correctCaseItemName = null;
        if (itemName != null) {
            correctCaseItemName = database.toCorrectCaseIdentifier(itemName);
        }
        return new DbItemIdentifier(type, database.getDatabaseName(), correctCaseSchemaName, correctCaseItemName, dbMaintainIdentifier);
    }
}

