/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.structure.clean.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.structure.clean.DBCleaner;
import org.dbmaintain.structure.model.DbItemIdentifier;
import org.dbmaintain.structure.model.DbItemType;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDBCleaner
implements DBCleaner {
    private static Log logger = LogFactory.getLog(DefaultDBCleaner.class);
    protected Set<DbItemIdentifier> itemsToPreserve;
    protected Databases databases;
    protected SQLHandler sqlHandler;

    public DefaultDBCleaner(Databases databases, Set<DbItemIdentifier> itemsToPreserve, SQLHandler sqlHandler) {
        this.databases = databases;
        this.sqlHandler = sqlHandler;
        this.itemsToPreserve = itemsToPreserve;
        this.assertItemsToPreserveExist(itemsToPreserve);
    }

    @Override
    public void cleanDatabase() {
        for (Database database : this.databases.getDatabases()) {
            for (String schemaName : database.getSchemaNames()) {
                if (this.itemsToPreserve.contains(DbItemIdentifier.getSchemaIdentifier(schemaName, database))) continue;
                logger.info("Cleaning database schema. Deleting all records from tables in schema " + schemaName);
                Set<String> tableNames = database.getTableNames(schemaName);
                for (String tableName : tableNames) {
                    if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.TABLE, schemaName, tableName, database))) continue;
                    this.cleanTable(database, schemaName, tableName);
                }
            }
        }
    }

    protected void cleanTable(Database database, String schemaName, String tableName) {
        logger.debug("Deleting all records from table " + tableName + " in database schema " + schemaName);
        this.sqlHandler.execute("delete from " + database.qualified(schemaName, tableName), database.getDataSource());
    }

    protected void assertItemsToPreserveExist(Set<DbItemIdentifier> itemsToPreserve) {
        HashMap<DbItemIdentifier, Set<DbItemIdentifier>> schemaTableNames = new HashMap<DbItemIdentifier, Set<DbItemIdentifier>>();
        for (DbItemIdentifier itemToPreserve : this.itemsToPreserve) {
            Database database = this.databases.getDatabase(itemToPreserve.getDatabaseName());
            if (database == null) continue;
            switch (itemToPreserve.getType()) {
                case SCHEMA: {
                    if (database.getSchemaNames().contains(itemToPreserve.getSchemaName())) break;
                    throw new DbMaintainException("Schema to preserve does not exist: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which schema's need to be preserved. To assure nothing is deleted by mistake, nothing will be deleted.");
                }
                case TABLE: {
                    Set<DbItemIdentifier> tableNames = (Set<DbItemIdentifier>)schemaTableNames.get(itemToPreserve.getSchema());
                    if (tableNames == null) {
                        tableNames = this.toDbItemIdentifiers(database, itemToPreserve.getSchemaName(), database.getTableNames(itemToPreserve.getSchemaName()));
                        schemaTableNames.put(itemToPreserve.getSchema(), tableNames);
                    }
                    if (itemToPreserve.isDbMaintainIdentifier() || tableNames.contains(itemToPreserve)) break;
                    throw new DbMaintainException("Table to preserve does not exist: " + itemToPreserve.getItemName() + " in schema: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which tables need to be preserved. To assure nothing is deleted by mistake, nothing will be deleted.");
                }
            }
        }
    }

    protected Set<DbItemIdentifier> toDbItemIdentifiers(Database database, String schemaName, Set<String> itemNames) {
        HashSet<DbItemIdentifier> result = new HashSet<DbItemIdentifier>();
        for (String itemName : itemNames) {
            result.add(DbItemIdentifier.getItemIdentifier(DbItemType.TABLE, schemaName, itemName, database));
        }
        return result;
    }
}

