/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.launch.task;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dbmaintain.MainFactory;
import org.dbmaintain.config.DbMaintainConfigurationLoader;
import org.dbmaintain.launch.task.TaskConfiguration;

public abstract class DbMaintainTask {
    private File configFile;
    private Properties environmentProperties;

    public boolean execute() {
        TaskConfiguration taskConfiguration = this.getTaskConfiguration(this.configFile);
        taskConfiguration.addAllConfiguration(this.environmentProperties);
        MainFactory mainFactory = this.createMainFactory(taskConfiguration);
        return this.doExecute(mainFactory);
    }

    protected abstract void addTaskConfiguration(TaskConfiguration var1);

    protected abstract boolean doExecute(MainFactory var1);

    protected TaskConfiguration getTaskConfiguration(File customConfigFile) {
        Properties configuration = new DbMaintainConfigurationLoader().loadConfiguration(customConfigFile);
        TaskConfiguration taskConfiguration = new TaskConfiguration(configuration);
        this.addTaskConfiguration(taskConfiguration);
        return taskConfiguration;
    }

    protected MainFactory createMainFactory(TaskConfiguration taskConfiguration) {
        Properties configuration = taskConfiguration.getConfiguration();
        Map<String, DataSource> dataSourcesPerDatabaseName = taskConfiguration.getDataSourcesPerDatabaseName();
        return new MainFactory(configuration, dataSourcesPerDatabaseName);
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setEnvironmentProperties(Properties environmentProperties) {
        this.environmentProperties = environmentProperties;
    }
}

