/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.multipart.Attribute;
import org.jboss.netty.handler.codec.http.multipart.DiskAttribute;
import org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.jboss.netty.handler.codec.http.multipart.MemoryAttribute;

public class MixedAttribute
implements Attribute {
    private Attribute attribute;
    private final long limitSize;

    public MixedAttribute(String name, long limitSize) {
        this.limitSize = limitSize;
        this.attribute = new MemoryAttribute(name);
    }

    public MixedAttribute(String name, String value2, long limitSize) {
        this.limitSize = limitSize;
        if ((long)value2.length() > this.limitSize) {
            try {
                this.attribute = new DiskAttribute(name, value2);
            }
            catch (IOException e) {
                try {
                    this.attribute = new MemoryAttribute(name, value2);
                }
                catch (IOException e1) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else {
            try {
                this.attribute = new MemoryAttribute(name, value2);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void addContent(ChannelBuffer buffer, boolean last2) throws IOException {
        if (this.attribute instanceof MemoryAttribute && this.attribute.length() + (long)buffer.readableBytes() > this.limitSize) {
            DiskAttribute diskAttribute = new DiskAttribute(this.attribute.getName());
            if (((MemoryAttribute)this.attribute).getChannelBuffer() != null) {
                diskAttribute.addContent(((MemoryAttribute)this.attribute).getChannelBuffer(), false);
            }
            this.attribute = diskAttribute;
        }
        this.attribute.addContent(buffer, last2);
    }

    public void delete() {
        this.attribute.delete();
    }

    public byte[] get() throws IOException {
        return this.attribute.get();
    }

    public ChannelBuffer getChannelBuffer() throws IOException {
        return this.attribute.getChannelBuffer();
    }

    public Charset getCharset() {
        return this.attribute.getCharset();
    }

    public String getString() throws IOException {
        return this.attribute.getString();
    }

    public String getString(Charset encoding) throws IOException {
        return this.attribute.getString(encoding);
    }

    public boolean isCompleted() {
        return this.attribute.isCompleted();
    }

    public boolean isInMemory() {
        return this.attribute.isInMemory();
    }

    public long length() {
        return this.attribute.length();
    }

    public boolean renameTo(File dest) throws IOException {
        return this.attribute.renameTo(dest);
    }

    public void setCharset(Charset charset) {
        this.attribute.setCharset(charset);
    }

    public void setContent(ChannelBuffer buffer) throws IOException {
        if ((long)buffer.readableBytes() > this.limitSize && this.attribute instanceof MemoryAttribute) {
            this.attribute = new DiskAttribute(this.attribute.getName());
        }
        this.attribute.setContent(buffer);
    }

    public void setContent(File file) throws IOException {
        if (file.length() > this.limitSize && this.attribute instanceof MemoryAttribute) {
            this.attribute = new DiskAttribute(this.attribute.getName());
        }
        this.attribute.setContent(file);
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (this.attribute instanceof MemoryAttribute) {
            this.attribute = new DiskAttribute(this.attribute.getName());
        }
        this.attribute.setContent(inputStream);
    }

    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return this.attribute.getHttpDataType();
    }

    public String getName() {
        return this.attribute.getName();
    }

    public int compareTo(InterfaceHttpData o) {
        return this.attribute.compareTo(o);
    }

    public String toString() {
        return "Mixed: " + this.attribute.toString();
    }

    public String getValue() throws IOException {
        return this.attribute.getValue();
    }

    public void setValue(String value2) throws IOException {
        this.attribute.setValue(value2);
    }

    public ChannelBuffer getChunk(int length) throws IOException {
        return this.attribute.getChunk(length);
    }

    public File getFile() throws IOException {
        return this.attribute.getFile();
    }
}

