/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.service;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.authentication.service.CertificateStore;
import de.justsoftware.authentication.service.JustHealthIndicator;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="certificateStore")
@ParametersAreNonnullByDefault
public class RedisCertificateStore
implements CertificateStore,
JustHealthIndicator,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCertificateStore.class);
    private static final String STORE_KEY_PREFIX = "certificateStore";
    private final RedisTemplate<String, String> _redisStringTemplate = new RedisTemplate();
    private final RedisTemplate<String, PrivateKey> _redisPrivateKeyTemplate = new RedisTemplate();
    private final RedisTemplate<String, X509Certificate> _redisCertificatesTemplate = new RedisTemplate();
    private final RedisTemplate<String, ImmutableList<String>> _redisStringListTemplate = new RedisTemplate();

    @Autowired
    public RedisCertificateStore(RedisConnectionFactory connectionFactory) {
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer jdkSerializationRedisSerializer = new JdkSerializationRedisSerializer();
        this._redisStringTemplate.setConnectionFactory(connectionFactory);
        this._redisStringTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        this._redisStringTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        this._redisStringTemplate.setValueSerializer((RedisSerializer)stringRedisSerializer);
        this._redisStringTemplate.setHashValueSerializer((RedisSerializer)stringRedisSerializer);
        this._redisPrivateKeyTemplate.setConnectionFactory(connectionFactory);
        this._redisPrivateKeyTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        this._redisPrivateKeyTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        this._redisPrivateKeyTemplate.setValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        this._redisPrivateKeyTemplate.setHashValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        this._redisCertificatesTemplate.setConnectionFactory(connectionFactory);
        this._redisCertificatesTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        this._redisCertificatesTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        this._redisCertificatesTemplate.setValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        this._redisCertificatesTemplate.setHashValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        this._redisStringListTemplate.setConnectionFactory(connectionFactory);
        this._redisStringListTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        this._redisStringListTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        this._redisStringListTemplate.setValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        this._redisStringListTemplate.setHashValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
    }

    public void afterPropertiesSet() throws Exception {
        this._redisStringTemplate.afterPropertiesSet();
        this._redisPrivateKeyTemplate.afterPropertiesSet();
        this._redisCertificatesTemplate.afterPropertiesSet();
        this._redisStringListTemplate.afterPropertiesSet();
    }

    public void doHealthCheck(Health.Builder builder) {
        builder.up();
        this.doHealthCheck(builder, this.getServiceProvider(), "ssl.sp.");
        this.doHealthCheck(builder, this.getIdentityProvider(), "ssl.idp.");
    }

    private void doHealthCheck(Health.Builder builder, @Nullable String key, String prefix) {
        if (!Strings.isNullOrEmpty((String)key)) {
            builder.withDetail(this.getHealthKey(prefix + "present"), (Object)Boolean.TRUE);
            this.getCertificateChain(key).forEach(cert -> {
                String alias = RedisCertificateStore.getX509Cn((X509Certificate)cert);
                try {
                    cert.checkValidity();
                    builder.withDetail(this.getHealthKey(prefix + alias), (Object)Boolean.TRUE);
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    LOGGER.error("Certificate " + alias + " for " + key + " is invalid:", (Throwable)e);
                    builder.withDetail(this.getHealthKey(prefix + alias), (Object)Boolean.FALSE);
                    builder.down();
                }
            });
        } else {
            builder.withDetail(this.getHealthKey(prefix + "present"), (Object)Boolean.FALSE);
            builder.down();
        }
    }

    @Nonnull
    private String getHealthKey(String key) {
        return key.replaceAll("[^a-zA-Z0-9\\.-]", "");
    }

    public void setPrivateKey(String alias, PrivateKey key) {
        this._redisPrivateKeyTemplate.boundValueOps((Object)this.redisPrivateKeyKey(alias)).set((Object)key);
    }

    public PrivateKey getPrivateKey(String alias) {
        return (PrivateKey)this._redisPrivateKeyTemplate.boundValueOps((Object)this.redisPrivateKeyKey(alias)).get();
    }

    public List<X509Certificate> getCertificateChain(String alias) {
        ImmutableList chainNames = (ImmutableList)this._redisStringListTemplate.boundValueOps((Object)this.redisChainKey(alias)).get();
        LOGGER.debug("loaded chain for alias {}: {}", (Object)alias, (Object)chainNames);
        return chainNames.stream().map(arg_0 -> this.getCertificate(arg_0)).filter(cert -> cert != null).collect(Collectors.toList());
    }

    public void setCertificateChain(String alias, List<X509Certificate> chain) {
        ImmutableList.Builder chainNamesBuilder = ImmutableList.builder();
        chain.forEach(cert -> {
            String name = RedisCertificateStore.getX509Cn((X509Certificate)cert);
            chainNamesBuilder.add((Object)name);
            this.setCertificate(name, cert);
        });
        ImmutableList chainNames = chainNamesBuilder.build();
        this._redisStringListTemplate.boundValueOps((Object)this.redisChainKey(alias)).set((Object)chainNames);
        LOGGER.debug("set chain for alias {}: {}", (Object)alias, (Object)chainNames);
    }

    @Nonnull
    private static String getX509Cn(X509Certificate cert) {
        try {
            X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return ((ASN1String)cn.getFirst().getValue()).getString();
        }
        catch (RuntimeException | CertificateEncodingException e) {
            return cert.getSubjectX500Principal().getName();
        }
    }

    private void setCertificate(String alias, X509Certificate cert) {
        this._redisCertificatesTemplate.boundValueOps((Object)this.redisCertKey(alias)).set((Object)cert);
    }

    public X509Certificate getCertificate(String alias) {
        return (X509Certificate)this._redisCertificatesTemplate.boundValueOps((Object)this.redisCertKey(alias)).get();
    }

    @Nonnull
    private String redisChainKey(String alias) {
        return "certificateStore:chain:" + alias;
    }

    @Nonnull
    private String redisPrivateKeyKey(String alias) {
        return "certificateStore:privateKey:" + alias;
    }

    @Nonnull
    private String redisCertKey(String alias) {
        return "certificateStore:cert:" + alias;
    }

    @Nonnull
    private String redisIdpKey() {
        return "certificateStore:provider:idp";
    }

    @Nonnull
    private String redisSpKey() {
        return "certificateStore:provider:sp";
    }

    public Set<String> getAliases() {
        return this._redisCertificatesTemplate.keys((Object)"certificateStore:cert:*").stream().map(k -> k.substring("certificateStore:cert:".length())).collect(Collectors.toSet());
    }

    public String getIdentityProvider() {
        return (String)this._redisStringTemplate.boundValueOps((Object)this.redisIdpKey()).get();
    }

    public void setIdentityProvider(String alias) {
        this._redisStringTemplate.boundValueOps((Object)this.redisIdpKey()).set((Object)alias);
    }

    public String getServiceProvider() {
        return (String)this._redisStringTemplate.boundValueOps((Object)this.redisSpKey()).get();
    }

    public void setServiceProvider(String alias) {
        this._redisStringTemplate.boundValueOps((Object)this.redisSpKey()).set((Object)alias);
    }
}

