/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.application;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.session.SessionAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.support.SpringBootServletInitializer;

@SpringBootApplication(scanBasePackages={"de.justsoftware"}, exclude={SessionAutoConfiguration.class})
@ParametersAreNonnullByDefault
public class Application
extends SpringBootServletInitializer {
    public static final String WEBAPP_CONTEXT_PATH = "/authentication";
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);
    private static final ImmutableMap<String, Object> PROPERTIES = ImmutableMap.builder().put((Object)"server.context-path", (Object)"/authentication").put((Object)"server.error.include-stacktrace ", (Object)"always").put((Object)"management.security.enabled", (Object)"false").put((Object)"management.context-path", (Object)"/manage").put((Object)"spring.config.name", (Object)"authentication-config").put((Object)"logging.config", (Object)"authentication-log4j2.yml").build();

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.properties((Map)PROPERTIES).profiles(new String[]{"production", "authentication"}).sources(new Class[]{Application.class});
    }

    public static void main(String[] args) {
        LOGGER.info("Starting authentication service....");
        Application application = new Application();
        application.configure(new SpringApplicationBuilder(new Object[]{Application.class})).profiles(new String[]{"standalone"}).build().run(args);
    }
}

