/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent.hierarchy;

import com.freiheit.superoperty.Domain;
import com.freiheit.superoperty.DomainHierarchyAdapter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.wings.SComponent;
import org.wings.SDimension;
import org.wings.SLabel;
import org.wings.SPanel;
import org.wings.STable;
import org.wings.style.CSSProperty;
import org.wings.table.STableCellRenderer;

@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="superoperty session should not be serialized")
public class NonSuperopertyClientOverviewPanel
extends SPanel {
    private static final long serialVersionUID = 3691037681748358457L;
    private final DomainTable _table;
    private final DomainHierarchyAdapter _adapter;

    public NonSuperopertyClientOverviewPanel(String domain, DomainHierarchyAdapter adapter) {
        this._adapter = adapter;
        List<Domain> clients = this._adapter.getNonSuperopertyChildDomains(domain);
        this._table = new DomainTable();
        this._table.setValues(new DomainTableModel(clients));
        this.add((SComponent)this._table);
    }

    private static class DomainTableCellRenderer
    implements STableCellRenderer {
        private final SLabel _textLabel = new SLabel();

        private DomainTableCellRenderer() {
        }

        public SComponent getTableCellRendererComponent(STable table, Object value, boolean selected, int row, int col) {
            this._textLabel.setHorizontalAlignment(0);
            if (value instanceof Domain) {
                Domain domain = (Domain)value;
                this._textLabel.setText(domain.getName());
            } else {
                this._textLabel.setText(value != null ? value.toString() : "null");
            }
            return this._textLabel;
        }
    }

    public static class DomainTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3691037681748358457L;
        private static final int COL_COUNT = 1;
        private final List<Domain> _affiliates;

        public DomainTableModel(List<Domain> affiliates) {
            this._affiliates = affiliates;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            int cols = 0;
            if (this._affiliates != null) {
                cols = this._affiliates.size() / this.getColumnCount();
                if (this._affiliates.size() % this.getColumnCount() > 0) {
                    ++cols;
                }
            }
            return cols;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int index = rowIndex * 1 + columnIndex;
            if (index < this._affiliates.size()) {
                return this._affiliates.get(index);
            }
            return "";
        }
    }

    public static class DomainTable
    extends STable {
        private static final long serialVersionUID = 3691037681748358457L;

        public DomainTable() {
            this.setHeaderVisible(false);
            this.setShowGrid(false);
            this.setSelectionMode(-1);
            this.setIntercellPadding(new SDimension("4", "4"));
            this.setIntercellSpacing(new SDimension("1", "1"));
            this.setDefaultRenderer(new DomainTableCellRenderer());
            this.setAttribute(SELECTOR_ALL, CSSProperty.WIDTH, "100%");
        }

        public void setValues(TableModel tableModel) {
            this.setModel(tableModel);
        }
    }
}

