/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent.hierarchy;

import com.freiheit.superoperty.Domain;
import com.freiheit.superoperty.DomainHierarchyAdapter;
import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.uicomponent.hierarchy.HierarchyConfigurationPanel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.wings.SButton;
import org.wings.SComponent;
import org.wings.SDimension;
import org.wings.SFlowDownLayout;
import org.wings.SFont;
import org.wings.SLabel;
import org.wings.SLayoutManager;
import org.wings.SPanel;
import org.wings.STable;
import org.wings.style.CSSProperty;
import org.wings.table.STableCellRenderer;

@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="superoperty session should not be serialized")
public class HierarchyOverviewPanel
extends SPanel {
    private static final long serialVersionUID = 3691037681748358457L;
    private final DomainTable _table;
    private final HierarchyConfigurationPanel _configurationPanel;
    private final DomainHierarchyAdapter _adapter;
    private char _firstChar;

    public HierarchyOverviewPanel(HierarchyConfigurationPanel panel, String domain, DomainHierarchyAdapter adapter) {
        this._configurationPanel = panel;
        this._adapter = adapter;
        List<Domain> affiliates = this._adapter.getChildDomains(domain);
        this._table = new DomainTable();
        this._table.setValues(new DomainTableModel(affiliates));
        this.add((SComponent)this._table);
    }

    private class DomainTableCellRenderer
    implements STableCellRenderer {
        private final SLabel _textLabel = new SLabel();

        public SComponent getTableCellRendererComponent(STable table, Object value, boolean selected, int row, int col) {
            this._textLabel.setHorizontalAlignment(0);
            if (value instanceof Domain) {
                SButton button;
                String label;
                SPanel panel = new SPanel();
                panel.setLayout((SLayoutManager)new SFlowDownLayout());
                panel.setAttribute(SComponent.SELECTOR_ALL, CSSProperty.WIDTH, "100%");
                final Domain domain = (Domain)value;
                String domainName = domain.getName();
                String displayDomain = domain.getDisplayDomain();
                char first = domainName.toLowerCase().charAt(0);
                if (first != HierarchyOverviewPanel.this._firstChar) {
                    panel.add((SComponent)new SLabel("<html><h2>" + first + "</h2>"));
                    HierarchyOverviewPanel.this._firstChar = first;
                }
                if ((label = "<html>" + this.escapeHtmlEntities(domainName)).length() > 30) {
                    label = label.substring(0, 30) + "...";
                }
                if (displayDomain != null && !domainName.equals(displayDomain)) {
                    label = label + "<br> (" + this.escapeHtmlEntities(displayDomain) + ")";
                }
                StringBuilder tooltipBuilder = new StringBuilder("<html><nobr>").append(this.escapeHtmlEntities(domainName)).append("</nobr><br>");
                List<Property> overriddenProperties = HierarchyOverviewPanel.this._adapter.getOverriddenProperties(domain.getDomain());
                if (overriddenProperties != null && overriddenProperties.size() > 0) {
                    button = new SButton(label + " [" + overriddenProperties.size() + "]");
                    SFont font = button.getFont();
                    if (font == null) {
                        font = new SFont();
                        font.setSize(9);
                    }
                    font.setStyle(1);
                    button.setFont(font);
                    for (Property prop : overriddenProperties) {
                        tooltipBuilder.append("<nobr>").append(this.escapeHtmlEntities(prop.getMetaProperty().getName())).append(" = ").append(this.escapeHtmlEntities(prop.getStringValue())).append("</nobr><br>");
                    }
                } else {
                    button = new SButton(label);
                }
                button.setShowAsFormComponent(false);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        HierarchyOverviewPanel.this._configurationPanel.showPropertyEditorPane(domain.getDomain());
                    }
                });
                panel.add((SComponent)button);
                return panel;
            }
            this._textLabel.setText(value != null ? value.toString() : "null");
            return this._textLabel;
        }

        private String escapeHtmlEntities(String s) {
            return s.replaceAll("\"", "&quot;").replaceAll("'", "");
        }
    }

    static class DomainTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3691037681748358457L;
        private static final int WRAP_COUNT = 20;
        private int _colCount = 4;
        private int _rowCount;
        private final List<Domain> _affiliates;

        public DomainTableModel(List<Domain> affiliates) {
            this._affiliates = affiliates;
            if (affiliates.size() < 60) {
                this._colCount = 3;
            }
            if (affiliates.size() < 40) {
                this._colCount = 2;
            }
            if (affiliates.size() < 20) {
                this._colCount = 1;
            }
            this._rowCount = affiliates.size() / this._colCount;
            if (affiliates.size() % this._colCount > 0) {
                ++this._rowCount;
            }
        }

        @Override
        public int getColumnCount() {
            return this._colCount;
        }

        @Override
        public int getRowCount() {
            return this._rowCount;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int index = rowIndex * this._colCount + columnIndex;
            if (index < this._affiliates.size()) {
                return this._affiliates.get(index);
            }
            return "";
        }
    }

    class DomainTable
    extends STable {
        private static final long serialVersionUID = 3691037681748358457L;

        public DomainTable() {
            this.setHeaderVisible(false);
            this.setShowGrid(false);
            this.setSelectionMode(-1);
            this.setIntercellPadding(new SDimension("4", "4"));
            this.setIntercellSpacing(new SDimension("1", "1"));
            this.setDefaultRenderer(new DomainTableCellRenderer());
            this.setAttribute(SELECTOR_ALL, CSSProperty.WIDTH, "100%");
        }

        public void setValues(TableModel tableModel) {
            this.setModel(tableModel);
        }
    }
}

