/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent.hierarchy;

import com.freiheit.superoperty.Domain;
import com.freiheit.superoperty.DomainHierarchyAdapter;
import com.freiheit.superoperty.SuperopertyContainer;
import com.freiheit.superoperty.uicomponent.AuthorizationAdapter;
import com.freiheit.superoperty.uicomponent.DomainPropertyEditorPane;
import com.freiheit.superoperty.uicomponent.hierarchy.BasePropertyEditorAccessor;
import com.freiheit.superoperty.uicomponent.hierarchy.HierarchyOverviewPanel;
import com.freiheit.superoperty.uicomponent.hierarchy.NonSuperopertyClientOverviewPanel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.wings.SButton;
import org.wings.SCardLayout;
import org.wings.SComponent;
import org.wings.SFlowDownLayout;
import org.wings.SFlowLayout;
import org.wings.SFont;
import org.wings.SLabel;
import org.wings.SLayoutManager;
import org.wings.SPanel;

@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="superoperty session should not be serialized")
public class HierarchyConfigurationPanel
extends SPanel {
    private static final long serialVersionUID = 3691037681748358457L;
    private static final String DOMAIN_OVERVIEW_PANEL = "AFFILIATE_OVERVIEW_PANEL_";
    private static final String NON_SUPEROPERTY_DOMAIN_OVERVIEW_PANEL = "PICKUPSTORE_OVERVIEW_PANEL_";
    private final SCardLayout _contentSwitcher = new SCardLayout();
    private final SButton _baseProperties;
    private final Set<String> _propertyEditorPanes = new HashSet<String>();
    private final Set<String> _domainOverviewPanels = new HashSet<String>();
    private final Set<String> _nonSuperopertyDomainOverviewPanels = new HashSet<String>();
    private final AuthorizationAdapter _authAdapter;
    private final DomainHierarchyAdapter _hierachyAdapter;
    private final SuperopertyContainer _superopertyContainer;

    public HierarchyConfigurationPanel(String domain, final BasePropertyEditorAccessor accessor, DomainHierarchyAdapter hierachyAdapter, AuthorizationAdapter authAdapter, SuperopertyContainer container) {
        this._hierachyAdapter = hierachyAdapter;
        this._authAdapter = authAdapter;
        this._superopertyContainer = container;
        this.setLayout((SLayoutManager)this._contentSwitcher);
        this._baseProperties = new SButton("Basis-Einstellungen");
        this._baseProperties.setShowAsFormComponent(false);
        this._baseProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                accessor.showBasisPropertyPanel();
            }
        });
        this.showPropertyEditorPane(domain);
    }

    public void showPropertyEditorPane(final String domain) {
        if (this._propertyEditorPanes.contains(domain)) {
            this._contentSwitcher.show((Object)domain);
            return;
        }
        ArrayList<SButton> path = new ArrayList<SButton>();
        path.add(this._baseProperties);
        path.addAll(this.getPath(domain));
        SButton btnChildDomains = null;
        List<Domain> childDomains = this._hierachyAdapter.getChildDomains(domain);
        if (childDomains != null && childDomains.size() > 0) {
            btnChildDomains = new SButton("Ebene tiefer");
            btnChildDomains.setShowAsFormComponent(true);
            btnChildDomains.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ArrayList<SButton> pathList = new ArrayList<SButton>();
                    pathList.add(HierarchyConfigurationPanel.this._baseProperties);
                    pathList.addAll(HierarchyConfigurationPanel.this.getPath(domain));
                    HierarchyConfigurationPanel.this.addOverviewButton(domain, pathList);
                    HierarchyConfigurationPanel.this.showDomainOverviewPanel(domain, pathList);
                }
            });
        }
        SButton btnNonSuperopertyChildDomains = null;
        List<Domain> nonSuperopertyChildDomains = this._hierachyAdapter.getNonSuperopertyChildDomains(domain);
        if (nonSuperopertyChildDomains != null && nonSuperopertyChildDomains.size() > 0) {
            btnNonSuperopertyChildDomains = new SButton("Filialen");
            btnNonSuperopertyChildDomains.setShowAsFormComponent(true);
            btnNonSuperopertyChildDomains.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ArrayList<SButton> pathList = new ArrayList<SButton>();
                    pathList.add(HierarchyConfigurationPanel.this._baseProperties);
                    pathList.addAll(HierarchyConfigurationPanel.this.getPath(domain));
                    HierarchyConfigurationPanel.this.addNonSuperopertyClientButton(pathList);
                    HierarchyConfigurationPanel.this.showNonSuperopertyDomainOverviewPanel(domain, pathList);
                }
            });
        }
        SPanel pathPanel = new SPanel();
        this.addPath(pathPanel, path);
        if (btnChildDomains != null || btnNonSuperopertyChildDomains != null) {
            pathPanel.add((SComponent)new SLabel("    >  "));
        }
        if (btnChildDomains != null) {
            pathPanel.add((SComponent)btnChildDomains);
        }
        if (btnNonSuperopertyChildDomains != null) {
            pathPanel.add((SComponent)btnNonSuperopertyChildDomains);
        }
        SPanel content = new SPanel();
        content.setLayout((SLayoutManager)new SFlowDownLayout());
        content.add((SComponent)pathPanel);
        content.add((SComponent)new DomainPropertyEditorPane(this._superopertyContainer, domain, this._authAdapter));
        this.add((SComponent)content, domain);
        this._contentSwitcher.show((Object)domain);
        this._propertyEditorPanes.add(domain);
    }

    private void showDomainOverviewPanel(String domain, List<SButton> path) {
        if (this._domainOverviewPanels.contains(domain)) {
            this._contentSwitcher.show((Object)(DOMAIN_OVERVIEW_PANEL + domain));
            return;
        }
        SPanel content = new SPanel();
        SPanel pathPanel = new SPanel();
        this.addPath(pathPanel, path);
        content.add((SComponent)pathPanel);
        content.add((SComponent)new HierarchyOverviewPanel(this, domain, this._hierachyAdapter));
        this.add((SComponent)content, DOMAIN_OVERVIEW_PANEL + domain);
        this._contentSwitcher.show((Object)(DOMAIN_OVERVIEW_PANEL + domain));
        this._domainOverviewPanels.add(domain);
    }

    private void showNonSuperopertyDomainOverviewPanel(String domain, List<SButton> path) {
        if (this._nonSuperopertyDomainOverviewPanels.contains(domain)) {
            this._contentSwitcher.show((Object)(NON_SUPEROPERTY_DOMAIN_OVERVIEW_PANEL + domain));
            return;
        }
        SPanel content = new SPanel();
        SPanel pathPanel = new SPanel();
        this.addPath(pathPanel, path);
        content.add((SComponent)pathPanel);
        content.add((SComponent)new NonSuperopertyClientOverviewPanel(domain, this._hierachyAdapter));
        this.add((SComponent)content, NON_SUPEROPERTY_DOMAIN_OVERVIEW_PANEL + domain);
        this._contentSwitcher.show((Object)(NON_SUPEROPERTY_DOMAIN_OVERVIEW_PANEL + domain));
        this._nonSuperopertyDomainOverviewPanels.add(domain);
    }

    private List<SButton> getPath(String domain) {
        if (this._hierachyAdapter.isRootDomain(domain)) {
            ArrayList<SButton> result = new ArrayList<SButton>();
            result.add(this.createShowDomainButton(domain));
            return result;
        }
        List<SButton> result = this.getPath(this._hierachyAdapter.getParentDomainFor(domain));
        this.addOverviewButton(domain, result);
        result.add(this.createShowDomainButton(domain));
        return result;
    }

    private void addOverviewButton(final String domain, final List<SButton> path) {
        SButton btn = new SButton("\u00dcbersicht");
        path.add(btn);
        btn.setShowAsFormComponent(false);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (HierarchyConfigurationPanel.this._hierachyAdapter.isRootDomain(domain)) {
                    HierarchyConfigurationPanel.this.showDomainOverviewPanel(domain, path);
                } else {
                    HierarchyConfigurationPanel.this.showDomainOverviewPanel(HierarchyConfigurationPanel.this._hierachyAdapter.getParentDomainFor(domain), path);
                }
            }
        });
    }

    private void addNonSuperopertyClientButton(List<SButton> path) {
        SButton btn = new SButton("Filialen");
        path.add(btn);
        this.setBold(btn);
        btn.setShowAsFormComponent(false);
        btn.setEnabled(false);
    }

    private SButton createShowDomainButton(final String domain) {
        SButton b = new SButton(this._hierachyAdapter.getDisplayName(domain));
        b.setShowAsFormComponent(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HierarchyConfigurationPanel.this._contentSwitcher.show((Object)domain);
            }
        });
        return b;
    }

    private void addPath(SPanel panel, List<SButton> path) {
        panel.setLayout((SLayoutManager)new SFlowLayout());
        Iterator<SButton> iter = path.iterator();
        while (iter.hasNext()) {
            SButton b = iter.next();
            panel.add((SComponent)b);
            if (iter.hasNext()) {
                panel.add((SComponent)new SLabel(" > "));
                continue;
            }
            this.setBold(b);
        }
    }

    private void setBold(SButton b) {
        SFont font = b.getFont();
        if (font == null) {
            font = new SFont();
            font.setSize(9);
        }
        font.setStyle(1);
        b.setFont(font);
    }
}

