/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.uicomponent;

import com.freiheit.superoperty.MetaProperty;
import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.editor.UIEditorFactory;
import com.freiheit.superoperty.uicomponent.AuthorizationAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.wings.SButton;
import org.wings.SComponent;
import org.wings.SForm;
import org.wings.SLabel;
import org.wings.SLayoutManager;
import org.wings.STemplateLayout;

abstract class AbstractEditorPanel
extends SForm {
    private static final long serialVersionUID = 200407232205L;
    protected final SLabel _editorDescription = new SLabel();
    protected final SLabel _saveError = new SLabel();
    protected UIEditorFactory _currentEditorFactory;
    private final SLabel _propertyPath = new SLabel();
    private final SLabel _propertyDescription = new SLabel();
    private final SButton _saveButton = new SButton("Sichern");
    private final AuthorizationAdapter _authAdapter;
    private int _lastVersion;
    private Property _currentProperty;
    private SComponent _currentEditorComponent;

    public AbstractEditorPanel(STemplateLayout layoutParam, AuthorizationAdapter authAdapter) {
        super((SLayoutManager)layoutParam);
        this._authAdapter = authAdapter;
        ActionListener storeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AbstractEditorPanel.this._currentEditorFactory == null) {
                    return;
                }
                AbstractEditorPanel.this.storeProperty();
            }
        };
        this._saveButton.addActionListener(storeListener);
        this.add((SComponent)this._propertyPath, "property-path");
        this.add((SComponent)this._propertyDescription, "property-description");
        this.add((SComponent)this._editorDescription, "editor-description");
        this.add((SComponent)this._saveButton, "editor-save-button");
        this.add((SComponent)this._saveError, "editor-save-error");
        this.setVisible(false);
    }

    protected final AuthorizationAdapter getAuthAdapter() {
        return this._authAdapter;
    }

    protected final Property getCurrentProperty() {
        return this._currentProperty;
    }

    protected abstract boolean mayEditCurrent();

    protected abstract boolean mayViewCurrent();

    protected void enableEditing(boolean mayEdit, boolean mayView) {
        this._saveButton.setEnabled(mayEdit);
        this._saveButton.setVisible(mayEdit);
        if (this._currentEditorComponent != null) {
            this._currentEditorComponent.setEnabled(mayEdit && mayView);
            this._currentEditorComponent.setVisible(mayView);
        }
    }

    private void refreshEditorComponent() {
        String value;
        this._lastVersion = this._currentProperty.getVersion();
        if (this._currentProperty.getParentProperty() != null && this._currentProperty.isValueInherited()) {
            Property showProp = this._currentProperty.getParentProperty();
            while (showProp.isValueInherited() && showProp.getParentProperty() != null) {
                showProp = showProp.getParentProperty() != null ? showProp.getParentProperty() : showProp;
            }
            value = showProp.getStringValue();
        } else {
            value = this._currentProperty.getStringValue();
        }
        this._currentEditorComponent = this._currentEditorFactory.createEditComponent(value);
        this.add(this._currentEditorComponent, "editor-component");
        this.enableEditing(this.mayEditCurrent(), this.mayViewCurrent());
    }

    public void setProperty(Property prop) {
        this._currentProperty = prop;
        if (this._currentProperty != null) {
            this.setVisible(true);
            MetaProperty meta = prop.getMetaProperty();
            this._propertyPath.setText(meta.getName());
            this._propertyDescription.setText(meta.getDescription());
            this._currentEditorFactory = meta.getConverter().getEditorFactory();
            this._editorDescription.setText(this._currentEditorFactory.getUserHint());
            this.refreshEditorComponent();
            this._saveError.setText("");
        } else {
            this._currentEditorFactory = null;
            this.setVisible(false);
        }
    }

    private void storeProperty() {
        this._saveError.setText("");
        String strValue = this._currentEditorFactory.extractEditedValue(this._currentEditorComponent);
        try {
            strValue = this._currentProperty.getMetaProperty().getConverter().checkValid(strValue);
            if (!this.mayEditCurrent()) {
                this._saveError.setText("Sie sind nicht berechtigt, diese Property zu bearbeiten.");
            } else if (this._lastVersion != this._currentProperty.getVersion()) {
                this._saveError.setText("Property wurde in der Zwischenzeit ge\u00e4ndert!");
            } else {
                this._currentProperty.setStringValue(strValue);
            }
        }
        catch (RuntimeException e) {
            this._saveError.setText(e.getMessage());
        }
        this.refreshEditorComponent();
    }
}

