/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.editor;

import com.freiheit.superoperty.editor.FontConstants;
import com.freiheit.superoperty.editor.UIEditorFactory;
import org.wings.SComponent;
import org.wings.STextArea;

public class TextareaEditorFactory
implements UIEditorFactory {
    private final String _userHint;
    private final int _cols;
    private final int _rows;

    public TextareaEditorFactory(String userHint, int cols, int rows) {
        this._userHint = userHint;
        this._cols = cols;
        this._rows = rows;
    }

    @Override
    public String getUserHint() {
        return this._userHint;
    }

    @Override
    public SComponent createEditComponent(String value) {
        STextArea field = new STextArea();
        if (value != null) {
            field.setText(value);
        }
        field.setFont(this._cols > 40 ? FontConstants.SMALL_WIDGET_FONT : FontConstants.WIDGET_FONT);
        field.setColumns(this._cols);
        field.setRows(this._rows);
        return field;
    }

    @Override
    public String extractEditedValue(SComponent comp) {
        return ((STextArea)comp).getText();
    }
}

