/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.editor;

import com.freiheit.superoperty.editor.UIEditorFactory;
import org.wings.SComponent;
import org.wings.SFont;
import org.wings.SList;

public class BooleanEditorFactory
implements UIEditorFactory {
    private static final String[] BOOL_VALUES = new String[]{"false", "true"};

    @Override
    public String getUserHint() {
        return "Boolscher Wert true=ein/false=aus";
    }

    @Override
    public SComponent createEditComponent(String value) {
        SList list = new SList((Object[])BOOL_VALUES);
        list.setSelectionMode(0);
        list.setVisibleRowCount(1);
        list.setSelectedIndex("false".equals(value) ? 0 : 1);
        list.setFont(new SFont("Sans-Serif", 0, 10));
        return list;
    }

    @Override
    public String extractEditedValue(SComponent comp) {
        SList list = (SList)comp;
        return (String)list.getSelectedValue();
    }
}

