/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.editor.StringEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;
import java.util.StringTokenizer;

public class SimpleStringConverter
implements PropertyStringConverter {
    private static final int DEFAULT_LIMIT = 4000;
    protected int _minLength;
    protected int _maxLength;
    protected boolean _mayBeNull;
    private UIEditorFactory _editorFactory;

    protected SimpleStringConverter(int minLen, int maxLen, boolean mayBeNull) {
        this._minLength = minLen;
        this._maxLength = maxLen;
        this._mayBeNull = mayBeNull;
    }

    public SimpleStringConverter() {
        this(-1, -1, false);
    }

    @Override
    public void setConfiguration(String config) throws IllegalArgumentException {
        int minLen = -1;
        int maxLen = -1;
        if (config != null && config.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(config, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("null".equalsIgnoreCase(token) || "mayBeNull".equalsIgnoreCase(token) || "nullable".equalsIgnoreCase(token)) {
                    this._mayBeNull = true;
                    continue;
                }
                int colPos = token.indexOf(58);
                if (colPos > 0) {
                    minLen = Integer.parseInt(token.substring(0, colPos).trim());
                    maxLen = Integer.parseInt(token.substring(colPos + 1).trim());
                    continue;
                }
                maxLen = Integer.parseInt(token.trim());
            }
        }
        this._minLength = minLen;
        this._maxLength = maxLen;
    }

    @Override
    public String checkValid(String storeString) throws IllegalArgumentException {
        if (!this._mayBeNull && storeString == null) {
            throw new IllegalArgumentException("Der String darf nicht NULL sein.");
        }
        if (storeString != null) {
            int strLen = storeString.length();
            if (strLen > 4000) {
                throw new IllegalArgumentException("Text (L\u00e4nge " + strLen + ") \u00fcberschreitet das Limit  von 4000 Zeichen");
            }
            if (this._maxLength >= 0 && strLen > this._maxLength) {
                throw new IllegalArgumentException("Text (L\u00e4nge " + strLen + ") L\u00e4nger als " + this._maxLength + " Zeichen");
            }
            if (this._minLength >= 0 && strLen < this._minLength) {
                throw new IllegalArgumentException("Text (L\u00e4nge " + strLen + ")  unterschreitet " + this._minLength + " Zeichen");
            }
        }
        return storeString;
    }

    @Override
    public Object convertToObject(String stringRepresentation) {
        this.checkValid(stringRepresentation);
        return stringRepresentation;
    }

    @Override
    public String convertFromObject(Object o) throws ClassCastException {
        return (String)o;
    }

    protected UIEditorFactory createEditorFactory() {
        return new StringEditorFactory("Ein String", this._maxLength);
    }

    @Override
    public final UIEditorFactory getEditorFactory() {
        if (this._editorFactory == null) {
            this._editorFactory = this.createEditorFactory();
        }
        return this._editorFactory;
    }
}

