/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.converter.SimpleStringConverter;
import com.freiheit.superoperty.editor.StringEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpCheckConverter
extends SimpleStringConverter {
    protected String _userHint;
    protected Pattern _pattern;

    @Override
    public void setConfiguration(String config) throws IllegalArgumentException {
        String regexpConfig;
        String lengthConfig;
        if (config == null) {
            super.setConfiguration(null);
            this._pattern = null;
            return;
        }
        int pipIdx = config.indexOf(124);
        if (pipIdx < 0) {
            lengthConfig = null;
            regexpConfig = config;
        } else {
            lengthConfig = config.substring(0, pipIdx);
            regexpConfig = config.substring(pipIdx + 1);
        }
        super.setConfiguration(lengthConfig);
        this._pattern = this.compilePattern(regexpConfig);
        this._userHint = regexpConfig;
    }

    protected Pattern compilePattern(String pattern) {
        return Pattern.compile(pattern);
    }

    protected String getFailureMessage(String str) {
        return "Das sieht mir nicht nach dem geforderten Muster aus";
    }

    @Override
    public String checkValid(String s) throws IllegalArgumentException {
        Matcher matcher;
        String result = super.checkValid(s);
        if (this._pattern != null && !(matcher = this._pattern.matcher(result)).matches()) {
            throw new IllegalArgumentException(this.getFailureMessage(result));
        }
        return result;
    }

    @Override
    protected UIEditorFactory createEditorFactory() {
        return new StringEditorFactory(this._userHint, this._maxLength);
    }
}

