/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.converter.SimpleStringConverter;
import com.freiheit.superoperty.editor.NumberEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;

public class LongConverter
extends SimpleStringConverter {
    private String _expression;
    private long _lowerBound;
    private long _upperBound;

    public LongConverter() {
        super.setConfiguration("0:19");
        this.setConfiguration(null);
    }

    @Override
    public void setConfiguration(String s) {
        long lowerBound = Long.MIN_VALUE;
        long upperBound = Long.MAX_VALUE;
        String config = s;
        if (config != null && (config = config.trim()).length() > 0) {
            boolean isEquals;
            int pos = 0;
            char firstChar = config.charAt(pos);
            boolean bl = isEquals = config.charAt(pos + 1) == '=';
            if (isEquals) {
                ++pos;
            }
            if (firstChar == '<') {
                upperBound = Long.parseLong(config.substring(pos + 1).trim());
                if (!isEquals) {
                    --upperBound;
                }
            } else if (firstChar == '>') {
                lowerBound = Long.parseLong(config.substring(pos + 1).trim());
                if (!isEquals) {
                    ++lowerBound;
                }
            } else {
                pos = config.indexOf("..");
                lowerBound = Long.parseLong(config.substring(0, pos).trim());
                upperBound = Long.parseLong(config.substring(pos + 2).trim());
            }
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException("Obere Grenze kleiner als untere");
        }
        this._expression = config;
        this._lowerBound = lowerBound;
        this._upperBound = upperBound;
    }

    @Override
    public String checkValid(String storeString) {
        super.checkValid(storeString);
        long value = 0L;
        try {
            value = Long.parseLong(storeString.trim());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("'" + storeString + "' ist keine Zahl");
        }
        if (value < this._lowerBound) {
            throw new IllegalArgumentException(value + ": Zahl kleiner als " + this._lowerBound);
        }
        if (value > this._upperBound) {
            throw new IllegalArgumentException(value + ": Zahl g\u00f6\u00dfer als " + this._upperBound);
        }
        return String.valueOf(value);
    }

    @Override
    public Object convertToObject(String stringRepresentation) {
        return Long.valueOf(this.checkValid(stringRepresentation));
    }

    @Override
    public String convertFromObject(Object o) throws ClassCastException {
        return o.toString();
    }

    @Override
    protected UIEditorFactory createEditorFactory() {
        return new NumberEditorFactory(this._expression, this._lowerBound, this._upperBound);
    }
}

