/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.converter.AbstractListConverter;
import com.freiheit.superoperty.converter.ListProvider;
import com.freiheit.superoperty.editor.ListEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;

public class ListConverter
extends AbstractListConverter
implements PropertyStringConverter {
    @Override
    public String checkValid(String stringRepresentation) throws IllegalArgumentException {
        ListProvider listProvider = this.getListProvider();
        if (listProvider == null) {
            throw new IllegalArgumentException("_listProvider is null");
        }
        for (String[] tuple : listProvider.getListItems()) {
            if (!stringRepresentation.equals(tuple[1])) continue;
            return stringRepresentation;
        }
        throw new IllegalArgumentException("value '" + stringRepresentation + "' not in list " + this.printTuples(listProvider.getListItems()));
    }

    @Override
    public Object convertToObject(String stringRepresentation) {
        ListProvider listProvider = this.getListProvider();
        if (listProvider != null) {
            for (String[] tuple : listProvider.getListItems()) {
                if (!stringRepresentation.equals(tuple[1])) continue;
                return tuple[0];
            }
        }
        return null;
    }

    @Override
    public String convertFromObject(Object o) throws ClassCastException {
        String value = (String)o;
        ListProvider listProvider = this.getListProvider();
        if (listProvider != null) {
            for (String[] tuple : listProvider.getListItems()) {
                if (!value.equals(tuple[0])) continue;
                return tuple[1];
            }
        }
        return null;
    }

    @Override
    public UIEditorFactory getEditorFactory() {
        return new ListEditorFactory(this.getListProvider());
    }
}

