/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.converter.SimpleStringConverter;
import com.freiheit.superoperty.editor.StringEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;

public class JavaClassNameConverter
extends SimpleStringConverter {
    private Class<?> _assignableTarget;

    public JavaClassNameConverter() {
        super(0, 512, false);
    }

    @Override
    public void setConfiguration(String config) {
        if (config != null && config.length() > 0) {
            try {
                this._assignableTarget = Class.forName(config);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Konfiguration falsch: " + e);
            }
        } else {
            this._assignableTarget = null;
        }
    }

    @Override
    public String checkValid(String storeString) throws IllegalArgumentException {
        super.checkValid(storeString);
        String className = storeString.trim();
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Eine Klasse mit Namen '" + className + "' kann nicht geladen werden");
        }
        if (this._assignableTarget != null && !this._assignableTarget.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Die Klasse '" + className + "' ist '" + this._assignableTarget + "' nicht zuweisbar");
        }
        return cls.getName();
    }

    @Override
    protected UIEditorFactory createEditorFactory() {
        Object msg = "Java Klasse";
        if (this._assignableTarget != null) {
            msg = (String)msg + ", zuweisbar zu " + this._assignableTarget.getName();
        }
        return new StringEditorFactory((String)msg, this._maxLength);
    }
}

