/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.editor.StringEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;
import java.net.MalformedURLException;
import java.net.URL;

public class HttpUrlStringConverter
implements PropertyStringConverter {
    @Override
    public String checkValid(String storeString) {
        URL url;
        if (storeString == null) {
            return null;
        }
        String resultUrl = storeString.trim();
        if (resultUrl.isEmpty()) {
            return null;
        }
        try {
            url = new URL(resultUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Not a URL");
        }
        String protocol = url.getProtocol();
        if (protocol == null || !protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("invaild protocol: " + protocol);
        }
        if (url.getPort() > 65535) {
            throw new IllegalArgumentException("invalid port: " + url.getPort() + " larger than 65535");
        }
        return resultUrl;
    }

    @Override
    public void setConfiguration(String config) {
    }

    @Override
    public Object convertToObject(String s) {
        return this.checkValid(s);
    }

    @Override
    public String convertFromObject(Object o) {
        return (String)o;
    }

    @Override
    public UIEditorFactory getEditorFactory() {
        return new StringEditorFactory("Eine HTTP-URL", -1);
    }
}

