/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.converter;

import com.freiheit.superoperty.converter.RegexpCheckConverter;
import com.freiheit.superoperty.editor.StringEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;

public class EmailStringConverter
extends RegexpCheckConverter {
    private static final String EMAIL_REGEXP = "[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*\\.[a-zA-Z]{2,4}";

    @Override
    public void setConfiguration(String config) {
        super.setConfiguration((config != null ? config : "0:250") + "|[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*\\.[a-zA-Z]{2,4}");
    }

    @Override
    protected String getFailureMessage(String str) {
        return "Keine g\u00fcltige eMail-Adresse: '" + str + "'";
    }

    @Override
    public String checkValid(String s) {
        String storeString = s != null ? s.trim() : null;
        return super.checkValid(storeString);
    }

    @Override
    protected UIEditorFactory createEditorFactory() {
        return new StringEditorFactory("Eine eMail-Adresse", this._maxLength);
    }
}

