/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty;

import com.freiheit.superoperty.BaseProperty;
import com.freiheit.superoperty.DomainHierarchyResolver;
import com.freiheit.superoperty.DomainProperty;
import com.freiheit.superoperty.FinalOverrideException;
import com.freiheit.superoperty.InheritanceType;
import com.freiheit.superoperty.MetaProperty;
import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import com.freiheit.superoperty.event.SuperopertyContainerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SuperopertyContainer {
    private final Map<String, MetaProperty> _metaProps;
    private final Map<MetaProperty, BaseProperty> _baseProps;
    private final Map<String, Map<MetaProperty, DomainProperty>> _domainToProps;
    private final List<SuperopertyContainerListener> _containerListeners;
    private final SuperopertyChangeListener _anyChangeListener;
    private final DomainHierarchyResolver _hierarchyResolver;

    public SuperopertyContainer() {
        this(new DomainHierarchyResolver(){

            @Override
            public String getParentDomainFor(String domain) {
                return null;
            }
        });
    }

    public SuperopertyContainer(DomainHierarchyResolver hierarchyResolver) {
        this._hierarchyResolver = hierarchyResolver;
        this._metaProps = Collections.synchronizedMap(new TreeMap());
        this._baseProps = Collections.synchronizedMap(new HashMap());
        this._domainToProps = Collections.synchronizedMap(new HashMap());
        this._containerListeners = new ArrayList<SuperopertyContainerListener>();
        this._anyChangeListener = new SuperopertyChangeListener(){

            @Override
            public void superopertyChange(SuperopertyChangeEvent event) {
                SuperopertyContainer.this.fireSuperopertyChangeEvent(event);
            }
        };
    }

    public MetaProperty getMetaProperty(String name) {
        if (name == null) {
            throw new NullPointerException("[null] given for name");
        }
        return this._metaProps.get(name);
    }

    public Collection<MetaProperty> getMetaProperties() {
        return Collections.unmodifiableCollection(this._metaProps.values());
    }

    public BaseProperty getBaseProperty(MetaProperty meta) {
        return this._baseProps.get(meta);
    }

    public DomainProperty getDomainProperty(MetaProperty meta, String domain) {
        if (meta.getInheritance() == InheritanceType.FINAL) {
            return null;
        }
        BaseProperty baseProp = this.getBaseProperty(meta);
        if (baseProp == null) {
            return null;
        }
        return this.getOrCreateDomainProperty(meta, domain, null);
    }

    public DomainProperty getDomainPropertyOrNull(MetaProperty meta, String domain) {
        if (meta.getInheritance() == InheritanceType.FINAL) {
            return null;
        }
        BaseProperty baseProp = this.getBaseProperty(meta);
        if (baseProp == null) {
            return null;
        }
        Map<MetaProperty, DomainProperty> perdomain = this._domainToProps.get(domain);
        if (perdomain == null) {
            return null;
        }
        return perdomain.get(meta);
    }

    public Collection<DomainProperty> getDomainProperties(MetaProperty meta) {
        ArrayList<DomainProperty> result = new ArrayList<DomainProperty>(this._domainToProps.size());
        for (Map<MetaProperty, DomainProperty> map : this._domainToProps.values()) {
            DomainProperty domProp = map.get(meta);
            if (domProp == null) continue;
            result.add(domProp);
        }
        return result;
    }

    public void addSuperopertyContainerListener(SuperopertyContainerListener listener) {
        this._containerListeners.add(listener);
    }

    public void removeSuperopertyContainerListener(SuperopertyContainerListener listener) {
        this._containerListeners.remove(listener);
    }

    public MetaProperty getOrCreateMetaProperty(String name, Class<? extends PropertyStringConverter> converter, String converterConfig, String description, InheritanceType inherit) {
        boolean isCreated;
        MetaProperty result;
        if (name == null) {
            throw new IllegalArgumentException("Property-Name cannot be null!");
        }
        if (this._metaProps.containsKey(name)) {
            result = this._metaProps.get(name);
            isCreated = false;
        } else {
            result = new MetaProperty(name);
            isCreated = true;
        }
        if (!result.isFinallyDefined()) {
            result.setDescription(description);
            boolean anyChange = result.setAndCheckConverterClass(converter, converterConfig);
            result.setInheritance(inherit);
            if (anyChange) {
                this.reCheckAllProperties(result);
            }
        }
        if (isCreated) {
            this._metaProps.put(name, result);
        }
        return result;
    }

    public Property getOrCreateProperty(MetaProperty meta, String domain, String defaultValue) {
        if (domain == null) {
            return this.getOrCreateBaseProperty(meta, defaultValue);
        }
        return this.getOrCreateDomainProperty(meta, domain, defaultValue);
    }

    private BaseProperty getOrCreateBaseProperty(MetaProperty meta, String defaultValue) {
        BaseProperty property;
        if (this._baseProps.containsKey(meta)) {
            property = this._baseProps.get(meta);
        } else {
            property = new BaseProperty(meta);
            property.addSuperopertyChangeListener(this._anyChangeListener);
            property.setStringValue(defaultValue);
            this._baseProps.put(meta, property);
        }
        return property;
    }

    private DomainProperty getOrCreateDomainProperty(MetaProperty meta, String domain, String defaultValue) throws FinalOverrideException {
        DomainProperty domainProperty;
        if (meta.getInheritance() == InheritanceType.FINAL) {
            throw new FinalOverrideException(meta, "attemt to override property for domain '" + domain + "'");
        }
        Map<MetaProperty, DomainProperty> domainPropNames = this._domainToProps.get(domain);
        if (domainPropNames == null) {
            domainPropNames = new HashMap<MetaProperty, DomainProperty>();
            this._domainToProps.put(domain, domainPropNames);
        }
        if (domainPropNames.containsKey(meta)) {
            domainProperty = domainPropNames.get(meta);
        } else {
            Property parent = this.getOrCreateProperty(meta, this._hierarchyResolver.getParentDomainFor(domain), defaultValue);
            domainProperty = new DomainProperty(parent, domain);
            domainProperty.addSuperopertyChangeListener(this._anyChangeListener);
            domainPropNames.put(meta, domainProperty);
        }
        return domainProperty;
    }

    public Property defineFinalProperty(String name, Class<? extends PropertyStringConverter> converter, String converterConfig, String description, String defaultValue) {
        MetaProperty meta = this.getOrCreateMetaProperty(name, converter, converterConfig, description, InheritanceType.FINAL);
        if (meta.isFinallyDefined()) {
            throw new IllegalStateException(meta.getName() + ": cannot define property twice");
        }
        BaseProperty result = this.getOrCreateBaseProperty(meta, defaultValue);
        meta.lockValues();
        this.fireMetaPropertyDefined(meta);
        return result;
    }

    private DomainProperty defineDomainProperty(String name, String domain, Class<? extends PropertyStringConverter> converter, String converterConfig, String description, String defaultValue, InheritanceType inheritance) {
        if (domain == null) {
            throw new IllegalArgumentException("Setting domain-property '" + name + "': domain cannot be null");
        }
        MetaProperty meta = this.getOrCreateMetaProperty(name, converter, converterConfig, description, inheritance);
        DomainProperty domainProperty = this.getOrCreateDomainProperty(meta, domain, defaultValue);
        if (domainProperty.isAlreadyDefined()) {
            throw new IllegalStateException(name + ": attempt to set domain property for domain '" + domain + "' twice");
        }
        if (!meta.isFinallyDefined()) {
            meta.lockValues();
            this.fireMetaPropertyDefined(meta);
        }
        domainProperty.setDefined();
        return domainProperty;
    }

    public DomainProperty defineAbstractProperty(String name, String domain, Class<? extends PropertyStringConverter> converter, String converterConfig, String description, String exampleValue) {
        return this.defineDomainProperty(name, domain, converter, converterConfig, description, exampleValue, InheritanceType.ABSTRACT);
    }

    public DomainProperty defineOverridableProperty(String name, String domain, Class<? extends PropertyStringConverter> converter, String converterConfig, String description, String defaultValue) {
        return this.defineDomainProperty(name, domain, converter, converterConfig, description, defaultValue, InheritanceType.OVERRIDABLE);
    }

    private void reCheckAllProperties(MetaProperty meta) throws IllegalArgumentException {
        this.reCheckProperty(this.getBaseProperty(meta));
        for (DomainProperty domProp : this.getDomainProperties(meta)) {
            if (domProp.isValueInherited()) continue;
            this.reCheckProperty(domProp);
        }
    }

    private void reCheckProperty(Property prop) throws IllegalArgumentException {
        if (prop == null) {
            return;
        }
        prop.setStringValue(prop.getStringValue());
    }

    private void fireSuperopertyChangeEvent(SuperopertyChangeEvent event) {
        for (SuperopertyContainerListener listener : this._containerListeners) {
            listener.anyPropertyChange(this, event);
        }
    }

    private void fireMetaPropertyDefined(MetaProperty meta) {
        for (SuperopertyContainerListener listener : this._containerListeners) {
            listener.metaPropertyDefined(this, meta);
        }
    }
}

