/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty;

import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.event.ChangeType;
import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import java.util.ArrayList;
import java.util.List;

class SuperopertyChangeSupport {
    private final List<SuperopertyChangeListener> _listenerList = new ArrayList<SuperopertyChangeListener>();

    SuperopertyChangeSupport() {
    }

    void addSuperopertyChangeListener(SuperopertyChangeListener listener) {
        this._listenerList.add(listener);
    }

    void removeSuperopertyChangeListener(SuperopertyChangeListener listener) {
        this._listenerList.remove(listener);
    }

    void fireValueAdded(Property property, String domain, String newString, Object newValue) {
        SuperopertyChangeEvent event = new SuperopertyChangeEvent(property, ChangeType.ADDED, domain, null, null, newString, newValue);
        this.fire(event);
    }

    void fireValueRemoved(Property property, String domain, String oldString, Object oldValue) {
        SuperopertyChangeEvent event = new SuperopertyChangeEvent(property, ChangeType.REMOVED, domain, oldString, oldValue, null, null);
        this.fire(event);
    }

    boolean fireIfValueChanged(Property property, String domain, String oldString, Object oldValue, String newString, Object newValue) {
        if (oldString == newString) {
            return false;
        }
        if (oldString != null && oldString.equals(newString)) {
            return false;
        }
        SuperopertyChangeEvent event = new SuperopertyChangeEvent(property, ChangeType.MODIFIED, domain, oldString, oldValue, newString, newValue);
        this.fire(event);
        return true;
    }

    private void fire(SuperopertyChangeEvent event) {
        for (SuperopertyChangeListener listener : this._listenerList) {
            listener.superopertyChange(event);
        }
    }
}

