/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty;

import com.freiheit.superoperty.AbstractPropertyAccessException;
import com.freiheit.superoperty.InheritanceType;
import com.freiheit.superoperty.MetaProperty;
import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.SuperopertyChangeSupport;
import com.freiheit.superoperty.event.SuperopertyChangeListener;

public final class BaseProperty
implements Property {
    private final MetaProperty _metaProperty;
    private volatile String _stringValue;
    private volatile Object _value;
    private final SuperopertyChangeSupport _changeSupport;
    private int _version = 0;

    BaseProperty(MetaProperty metaProperty) {
        this._metaProperty = metaProperty;
        this._changeSupport = new SuperopertyChangeSupport();
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public Property getParentProperty() {
        return null;
    }

    @Override
    public MetaProperty getMetaProperty() {
        return this._metaProperty;
    }

    @Override
    public boolean isValueInherited() {
        return true;
    }

    @Override
    public void clearLocalValue() {
        throw new UnsupportedOperationException("cannot clear a base property");
    }

    @Override
    public Object getValue() {
        if (this._metaProperty.getInheritance() == InheritanceType.ABSTRACT) {
            throw new AbstractPropertyAccessException(this._metaProperty, "This property is abstract and must be overridden; cannot access the base property");
        }
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) throws IllegalArgumentException {
        BaseProperty baseProperty = this;
        synchronized (baseProperty) {
            String oldString = this._stringValue;
            Object oldValue = this._value;
            PropertyStringConverter converter = this._metaProperty.getConverter();
            this._stringValue = converter.convertFromObject(value);
            this._value = value;
            ++this._version;
            if (!this._changeSupport.fireIfValueChanged(this, null, oldString, oldValue, this._stringValue, this._value)) {
                --this._version;
            }
        }
    }

    @Override
    public String getStringValue() {
        return this._stringValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(String value) throws IllegalArgumentException {
        BaseProperty baseProperty = this;
        synchronized (baseProperty) {
            String oldString = this._stringValue;
            Object oldValue = this._value;
            PropertyStringConverter converter = this._metaProperty.getConverter();
            String newValue = converter.checkValid(value);
            this._value = converter.convertToObject(newValue);
            this._stringValue = newValue;
            ++this._version;
            if (!this._changeSupport.fireIfValueChanged(this, null, oldString, oldValue, this._stringValue, this._value)) {
                --this._version;
            }
        }
    }

    @Override
    public void addSuperopertyChangeListener(SuperopertyChangeListener listener) {
        this._changeSupport.addSuperopertyChangeListener(listener);
    }

    @Override
    public void removeSuperopertyChangeListener(SuperopertyChangeListener listener) {
        this._changeSupport.removeSuperopertyChangeListener(listener);
    }
}

