/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis;

import com.ibatis.common.xml.NodeletException;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapConfigParser;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.transaction.external.ExternalTransactionConfig;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.lob.LobHandler;

public class SqlMapClientFactoryBean
implements FactoryBean<SqlMapClient>,
InitializingBean {
    private static final ThreadLocal<LobHandler> CONFIG_TIME_LOB_HANDLER_HOLDER = new ThreadLocal();
    private List<Resource> _configLocations;
    private List<Resource> _mappingLocations;
    private Properties _sqlMapClientProperties;
    private DataSource _dataSource;
    private boolean _useTransactionAwareDataSource = true;
    private Class<? extends TransactionConfig> _transactionConfigClass = ExternalTransactionConfig.class;
    private Properties _transactionConfigProperties = new Properties();
    private LobHandler _lobHandler;
    private SqlMapClient _sqlMapClient;

    public SqlMapClientFactoryBean() {
        this._transactionConfigProperties.setProperty("SetAutoCommitAllowed", "false");
    }

    public static LobHandler getConfigTimeLobHandler() {
        return CONFIG_TIME_LOB_HANDLER_HOLDER.get();
    }

    public void setConfigLocation(Resource configLocation) {
        this._configLocations = configLocation != null ? Collections.singletonList(configLocation) : null;
    }

    public void setConfigLocations(Resource[] configLocations) {
        this._configLocations = new ArrayList<Resource>(configLocations.length);
        for (Resource resource : configLocations) {
            this._configLocations.add(resource);
        }
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this._mappingLocations = new ArrayList<Resource>(mappingLocations.length);
        for (Resource resource : mappingLocations) {
            this._mappingLocations.add(resource);
        }
    }

    public void setSqlMapClientProperties(Properties sqlMapClientProperties) {
        this._sqlMapClientProperties = sqlMapClientProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setUseTransactionAwareDataSource(boolean useTransactionAwareDataSource) {
        this._useTransactionAwareDataSource = useTransactionAwareDataSource;
    }

    public void setTransactionConfigClass(Class<? extends TransactionConfig> transactionConfigClass) {
        if (transactionConfigClass == null || !TransactionConfig.class.isAssignableFrom(transactionConfigClass)) {
            throw new IllegalArgumentException("Invalid transactionConfigClass: does not implement com.ibatis.sqlmap.engine.transaction.TransactionConfig");
        }
        this._transactionConfigClass = transactionConfigClass;
    }

    public void setTransactionConfigProperties(Properties transactionConfigProperties) {
        this._transactionConfigProperties = transactionConfigProperties;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this._lobHandler = lobHandler;
    }

    public void afterPropertiesSet() throws IOException, InstantiationException, IllegalAccessException, SQLException, TransactionException {
        if (this._lobHandler != null) {
            CONFIG_TIME_LOB_HANDLER_HOLDER.set(this._lobHandler);
        }
        try {
            this._sqlMapClient = this.buildSqlMapClient(this._configLocations, this._mappingLocations, this._sqlMapClientProperties);
            if (this._dataSource != null) {
                TransactionConfig transactionConfig = this._transactionConfigClass.newInstance();
                DataSource dataSourceToUse = this._dataSource;
                if (this._useTransactionAwareDataSource && !(this._dataSource instanceof TransactionAwareDataSourceProxy)) {
                    dataSourceToUse = new TransactionAwareDataSourceProxy(this._dataSource);
                }
                transactionConfig.setDataSource(dataSourceToUse);
                transactionConfig.initialize(this._transactionConfigProperties);
                this.applyTransactionConfig(this._sqlMapClient, transactionConfig);
            }
        }
        finally {
            if (this._lobHandler != null) {
                CONFIG_TIME_LOB_HANDLER_HOLDER.remove();
            }
        }
    }

    protected SqlMapClient buildSqlMapClient(Iterable<Resource> configLocations, Iterable<Resource> mappingLocations, Properties properties) throws IOException {
        if (configLocations == null || !configLocations.iterator().hasNext()) {
            throw new IllegalArgumentException("At least 1 'configLocation' entry is required");
        }
        SqlMapClient client = null;
        SqlMapConfigParser configParser = new SqlMapConfigParser();
        for (Resource configLocation : configLocations) {
            InputStream is = configLocation.getInputStream();
            try {
                client = configParser.parse(is, properties);
            }
            catch (RuntimeException ex) {
                throw new NestedIOException("Failed to parse config resource: " + configLocation, ex.getCause());
            }
        }
        if (mappingLocations != null) {
            SqlMapParser mapParser = SqlMapParserFactory.createSqlMapParser(configParser);
            for (Resource mappingLocation : mappingLocations) {
                try {
                    mapParser.parse(mappingLocation.getInputStream());
                }
                catch (NodeletException ex) {
                    throw new NestedIOException("Failed to parse mapping resource: " + mappingLocation, (Throwable)ex);
                }
            }
        }
        return client;
    }

    protected void applyTransactionConfig(SqlMapClient sqlMapClient, TransactionConfig transactionConfig) {
        if (!(sqlMapClient instanceof ExtendedSqlMapClient)) {
            throw new IllegalArgumentException("Cannot set TransactionConfig with DataSource for SqlMapClient if not of type ExtendedSqlMapClient: " + sqlMapClient);
        }
        ExtendedSqlMapClient extendedClient = (ExtendedSqlMapClient)sqlMapClient;
        transactionConfig.setMaximumConcurrentTransactions(extendedClient.getDelegate().getMaxTransactions());
        extendedClient.getDelegate().setTxManager(new TransactionManager(transactionConfig));
    }

    public SqlMapClient getObject() {
        return this._sqlMapClient;
    }

    public Class<? extends SqlMapClient> getObjectType() {
        return this._sqlMapClient != null ? this._sqlMapClient.getClass() : SqlMapClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static class SqlMapParserFactory {
        private SqlMapParserFactory() {
        }

        public static SqlMapParser createSqlMapParser(SqlMapConfigParser configParser) {
            XmlParserState state = null;
            try {
                Field stateField = SqlMapConfigParser.class.getDeclaredField("state");
                stateField.setAccessible(true);
                state = (XmlParserState)stateField.get(configParser);
            }
            catch (IllegalAccessException | NoSuchFieldException | RuntimeException ex) {
                throw new IllegalStateException("iBATIS 2.3.2 'state' field not found in SqlMapConfigParser class - please upgrade to IBATIS 2.3.2 or higher in order to use the new 'mappingLocations' feature. " + ex);
            }
            return new SqlMapParser(state);
        }
    }
}

