/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.app.search.model.SearchFilter;
import de.justsoftware.app.search.model.SearchTeaser;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchResult {
    private final long _offset;
    private final long _count;
    private final ImmutableList<SearchTeaser> _teasers;
    private final ImmutableList<SearchFilter> _filters;
    private final SearchFilter _contextFilter;
    private final ImmutableList<String> _sortTypes;
    private final String _selectedSortType;
    private final String _searchToken;

    @JsonCreator
    public SearchResult(@JsonProperty(value="offset") long offset, @JsonProperty(value="count") long count, @JsonProperty(value="teasers") Iterable<SearchTeaser> teasers, @JsonProperty(value="filters") Iterable<SearchFilter> filters, @JsonProperty(value="contextFilter") SearchFilter contextFilter, @JsonProperty(value="sortTypes") Iterable<String> sortTypes, @JsonProperty(value="selectedSortType") String selectedSortType, @JsonProperty(value="searchToken") String searchToken) {
        this._offset = offset;
        this._count = count;
        this._teasers = ImmutableList.copyOf(teasers);
        this._filters = ImmutableList.copyOf(filters);
        this._contextFilter = contextFilter;
        this._sortTypes = ImmutableList.copyOf(sortTypes);
        this._selectedSortType = selectedSortType;
        this._searchToken = searchToken;
    }

    public long getOffset() {
        return this._offset;
    }

    public long getCount() {
        return this._count;
    }

    @Nonnull
    public ImmutableList<SearchTeaser> getTeasers() {
        return this._teasers;
    }

    @Nonnull
    public ImmutableList<SearchFilter> getFilters() {
        return this._filters;
    }

    @Nonnull
    public SearchFilter getContextFilter() {
        return this._contextFilter;
    }

    @Nonnull
    public ImmutableList<String> getSortTypes() {
        return this._sortTypes;
    }

    @Nonnull
    public String getSelectedSortType() {
        return this._selectedSortType;
    }

    @Nonnull
    public String getSearchToken() {
        return this._searchToken;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this._offset).add("count", this._count).add("teasers", this._teasers).add("filters", this._filters).add("contextFilter", (Object)this._contextFilter).add("sortTypes", this._sortTypes).add("selectedSortType", (Object)this._selectedSortType).add("searchToken", (Object)this._searchToken).toString();
    }
}

