/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.app.search.model.SearchFilterOptionRequest;
import de.justsoftware.app.search.model.SelectedSearchFilterOptions;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchRequest {
    private final String _searchString;
    private final ImmutableList<SelectedSearchFilterOptions> _searchFilterOptions;
    private final String _sortType;
    private final String _context;
    private final String _contextId;
    private final SearchFilterOptionRequest _searchForOptions;
    private final String _searchProvider;

    public SearchRequest(@Nullable String searchString, @Nullable Iterable<SelectedSearchFilterOptions> searchFilterOptions, @Nullable SortType sortType, @Nullable SearchContext context, @Nullable GlobalId contextId, @Nullable SearchProviderId searchProvider) {
        this(searchString, searchFilterOptions, sortType != null ? sortType.name() : null, context != null ? context.name() : null, contextId != null ? contextId.asString() : null, null, searchProvider != null ? searchProvider.getId() : null);
    }

    @JsonCreator
    public SearchRequest(@Nullable @JsonProperty(value="searchString", required=false) String searchString, @Nullable @JsonProperty(value="searchFilterOptions", required=false) Iterable<SelectedSearchFilterOptions> searchFilterOptions, @Nullable @JsonProperty(value="sortType", required=false) String sortType, @Nullable @JsonProperty(value="context") String context, @Nullable @JsonProperty(value="contextId", required=false) String contextId, @Nullable @JsonProperty(value="searchForOptions", required=false) SearchFilterOptionRequest searchForOptions, @Nullable @JsonProperty(value="searchProvider", required=false) String searchProvider) {
        this._searchString = searchString;
        this._searchFilterOptions = searchFilterOptions != null ? ImmutableList.copyOf(searchFilterOptions) : ImmutableList.of();
        this._sortType = sortType;
        this._context = context;
        this._contextId = contextId;
        this._searchForOptions = searchForOptions;
        this._searchProvider = searchProvider;
    }

    @CheckForNull
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSearchString() {
        return this._searchString;
    }

    @Nonnull
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableList<SelectedSearchFilterOptions> getSearchFilterOptions() {
        return this._searchFilterOptions;
    }

    @Nonnull
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public SearchFilterOptionRequest getSearchForOptions() {
        return this._searchForOptions;
    }

    @CheckForNull
    public String getSortType() {
        return this._sortType;
    }

    @CheckForNull
    public String getContext() {
        return this._context;
    }

    @CheckForNull
    public String getContextId() {
        return this._contextId;
    }

    @CheckForNull
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSearchProvider() {
        return this._searchProvider;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("searchString", (Object)this._searchString).add("searchFilterOptions", this._searchFilterOptions).add("sortType", (Object)this._sortType).add("context", (Object)this._context).add("contextId", (Object)this._contextId).add("searchForOptions", (Object)this._searchForOptions).add("searchProvider", (Object)this._searchProvider).toString();
    }
}

