/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.business.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.collect.ImmutableList;
import de.justsoftware.app.search.business.StoredSearchService;
import de.justsoftware.app.search.model.StoredSearchFilter;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.searchnew.business.model.DBStoredSearchFilter;
import de.justsoftware.onx.searchnew.business.model.StoredSearchFilterId;
import de.justsoftware.onx.searchnew.integration.persistence.SearchFilterDAO;
import de.justsoftware.toolbox.clock.Clock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class StoredSearchServiceImpl
implements StoredSearchService {
    private final SearchFilterDAO _searchFilterDAO;
    private final Clock _clock;

    @Autowired
    public StoredSearchServiceImpl(SearchFilterDAO searchFilterDAO, Clock clock) {
        this._searchFilterDAO = searchFilterDAO;
        this._clock = clock;
    }

    @Override
    public ImmutableList<StoredSearchFilter> getStoredSearchFilter(AuthorizationContextWithUserId authCtx) {
        return this._searchFilterDAO.getStoredSearchFilterByPersonId(authCtx.getUserId()).stream().map(StoredSearchFilter::fromDB).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    @Override
    public void createStoredSearchFilter(AuthorizationContextWithUserId authCtx, String name, String searchFilter) {
        String normalizedFilter = this.normalizeFilter(searchFilter);
        this._searchFilterDAO.insertStoredSearchFilter(new DBStoredSearchFilter(authCtx.getUserId(), name, normalizedFilter, this._clock.now()));
    }

    @Nonnull
    private String normalizeFilter(String filter) {
        if (filter.startsWith("#")) {
            return filter;
        }
        return "#" + filter;
    }

    @Override
    public void deleteStoredSearchFilter(AuthorizationContextWithUserId authCtx, long id) throws PermissionDeniedException {
        StoredSearchFilterId dbSearchFilterId = new StoredSearchFilterId(id);
        DBStoredSearchFilter searchFilter = this._searchFilterDAO.getStoredSearchFilterById(dbSearchFilterId);
        if (searchFilter == null) {
            return;
        }
        if (!authCtx.getUserId().equals((Object)searchFilter.getPersonId())) {
            throw new PermissionDeniedException("You don't have the permission to delete search filter: " + id);
        }
        this._searchFilterDAO.deleteStoredSearchFilter(dbSearchFilterId);
    }

    @Override
    public void deleteStoredSearchFilter(PersonId personId) {
        this._searchFilterDAO.deleteStoredSearchFilterByPersonId(personId);
    }
}

