/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.api.controller.support;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import de.justsoftware.app.search.model.JustSearchError;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolationException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackages={"de.justsoftware.app.search.api"})
@ParametersAreNonnullByDefault
public class JustSearchExceptionHandlingControllerAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(JustSearchExceptionHandlingControllerAdvice.class);

    @ExceptionHandler(value={PermissionDeniedException.class})
    @Nonnull
    public ResponseEntity<JustSearchError> handlePermissionDeniedException(Throwable t) {
        LOG.debug("permission denied", t);
        return this.createJustSearchError(t, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={NotLoggedInException.class})
    @Nonnull
    public ResponseEntity<JustSearchError> handleNotLoggedInException(NotLoggedInException e) {
        LOG.debug("unauthorized", (Throwable)e);
        return this.createJustSearchError((Throwable)e, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={TokenUtil.TokenParseException.class})
    @Nonnull
    public ResponseEntity<JustSearchError> handleTokenParseException(NotLoggedInException e) {
        LOG.debug("Invalid history token", (Throwable)e);
        return this.createJustSearchError((Throwable)e, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, InvalidIdServiceException.class, JucoConstraintViolationException.class})
    @Nonnull
    public ResponseEntity<JustSearchError> handleHttpMessageNotReadableException(Throwable t) {
        LOG.debug("invalid http message", t);
        return this.createJustSearchError(t, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ResponseEntity<JustSearchError> handleThrowable(Throwable t) {
        LOG.error("some unexpected error happened: ", t);
        return this.createJustSearchError(t, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Nonnull
    private ResponseEntity<JustSearchError> createJustSearchError(Throwable t, HttpStatus status) {
        return new ResponseEntity((Object)new JustSearchError(t.getClass().getSimpleName() + ": " + t.getMessage()), status);
    }
}

