/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.search.api.controller;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.app.search.model.SearchSettings;
import de.justsoftware.onx.common.shared.model.StringId;
import de.justsoftware.onx.searchnew.business.SearchDispatcherService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/search/api/v1/searchSettings"})
@Api(tags={"SearchSettings"})
public class SearchSettingsController {
    private final Settings _settings;
    private final SearchDispatcherService _searchDispatcherService;

    @Autowired
    public SearchSettingsController(Settings settings, SearchDispatcherService searchDispatcherService) {
        this._settings = settings;
        this._searchDispatcherService = searchDispatcherService;
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Retrieve all relevant settings.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns the search settings"), @ApiResponse(code=500, message="fatal error -  some internal error")})
    public SearchSettings getSearchSettings() {
        ImmutableSet searchProviders = FluentIterable.from((Iterable)this._searchDispatcherService.getProviderSet()).transform(StringId::getId).toSet();
        String invisibleContextFilterId = this._settings.getSearchContextShown() ? null : "CONTEXT";
        return new SearchSettings((ImmutableSet<String>)searchProviders, invisibleContextFilterId);
    }
}

