/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.profile.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.profile.model.ProfileModuleType;
import de.justsoftware.profile.api.model.ProfileSectionConfiguration;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileAttributesConfiguration {
    private final ImmutableSet<ProfileModuleType> _modules;
    private final ImmutableSet<String> _editableRoles;
    private final ImmutableList<ProfileSectionConfiguration> _sections;
    private final ImmutableSet<String> _hiddenPersonFields;
    private final ImmutableSet<String> _restrictedPersonFields;

    @JsonCreator
    public ProfileAttributesConfiguration(@JsonProperty(value="modules", required=true) ImmutableSet<ProfileModuleType> modules, @Nullable @JsonProperty(value="editableRoles", required=false) ImmutableSet<String> editableRoles, @JsonProperty(value="sections", required=true) ImmutableList<ProfileSectionConfiguration> sections, @Nullable @JsonProperty(value="hiddenPersonFields", required=false) ImmutableSet<String> hiddenPersonFields, @Nullable @JsonProperty(value="restrictedPersonFields", required=false) ImmutableSet<String> restrictedPersonFields) {
        this._modules = modules;
        this._editableRoles = editableRoles;
        this._sections = sections;
        this._hiddenPersonFields = hiddenPersonFields;
        this._restrictedPersonFields = restrictedPersonFields;
    }

    @Nonnull
    public ImmutableList<ProfileSectionConfiguration> getSections() {
        return this._sections;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public ImmutableSet<String> getEditableRoles() {
        return this._editableRoles;
    }

    @Nonnull
    public ImmutableSet<ProfileModuleType> getModules() {
        return this._modules;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public ImmutableSet<String> getHiddenPersonFields() {
        return this._hiddenPersonFields;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public ImmutableSet<String> getRestrictedPersonFields() {
        return this._restrictedPersonFields;
    }
}

