/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.profile.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.freiheit.toro.account.shared.model.settings.BirthdayVisibility;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.profile.api.model.Birthday;
import de.justsoftware.profile.api.model.ProfileAttributes;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Profile {
    private final ProfileId _id;
    private final String _fullname;
    private final String _title;
    private final String _firstname;
    private final String _lastname;
    private final String _additionalTitle;
    private final String _publicImageUrl;
    private final ImmutableSet<String> _roles;
    private final boolean _active;
    private final boolean _blocked;
    private final boolean _deleted;
    private final boolean _visible;
    private final ProfileAttributes _profileAttributes;
    private final ImmutableSet<String> _allowedActions;
    private final boolean _usesDefaultImage;
    private final Birthday _birthday;
    private final BirthdayVisibility _birthdayVisibility;
    private final TimeZone _timezone;
    private final boolean _acceptedProfileImageLegalTerms;

    @JsonCreator
    public Profile(@JsonProperty(value="id", required=true) ProfileId id, @JsonProperty(value="fullname", required=true) String fullname, @Nullable @JsonProperty(value="title", required=false) String title, @JsonProperty(value="firstname", required=true) String firstname, @JsonProperty(value="lastname", required=true) String lastname, @Nullable @JsonProperty(value="additionalTitle", required=false) String additionalTitle, @Nullable @JsonProperty(value="publicImageUrl", required=false) String publicImageUrl, @JsonProperty(value="roles", required=true) ImmutableSet<String> roles, @JsonProperty(value="active", required=false) boolean active, @JsonProperty(value="blocked", required=false) boolean blocked, @JsonProperty(value="deleted", required=false) boolean deleted, @JsonProperty(value="visible", required=false) boolean visible, @Nullable @JsonProperty(value="allowedActions", required=false) ImmutableSet<String> allowedActions, @Nullable @JsonProperty(value="profileAttributes", required=false) ProfileAttributes profileAttributes, @JsonProperty(value="usesDefaultImage", required=false) boolean usesDefaultImage, @Nullable @JsonProperty(value="birthday", required=false) Birthday birthday, @Nullable @JsonProperty(value="birthdayVisibility", required=false) BirthdayVisibility birthdayVisibility, @Nullable @JsonProperty(value="timezone", required=false) TimeZone timezone, @JsonProperty(value="acceptedProfileImageLegalTerms", required=false) boolean acceptedProfileImageLegalTerms) {
        this._id = id;
        this._fullname = fullname;
        this._firstname = firstname;
        this._lastname = lastname;
        this._publicImageUrl = publicImageUrl;
        this._roles = roles;
        this._active = active;
        this._blocked = blocked;
        this._deleted = deleted;
        this._profileAttributes = profileAttributes;
        this._visible = visible;
        this._allowedActions = allowedActions != null ? allowedActions : ImmutableSet.of();
        this._usesDefaultImage = usesDefaultImage;
        this._title = title;
        this._additionalTitle = additionalTitle;
        this._birthday = birthday;
        this._birthdayVisibility = birthdayVisibility;
        this._timezone = timezone;
        this._acceptedProfileImageLegalTerms = acceptedProfileImageLegalTerms;
    }

    @Nonnull
    public ProfileId getId() {
        return this._id;
    }

    @Nonnull
    public String getFullname() {
        return this._fullname;
    }

    @Nonnull
    public String getFirstname() {
        return this._firstname;
    }

    @Nonnull
    public String getLastname() {
        return this._lastname;
    }

    @CheckForNull
    public String getTitle() {
        return this._title;
    }

    @CheckForNull
    public String getAdditionalTitle() {
        return this._additionalTitle;
    }

    @CheckForNull
    public String getPublicImageUrl() {
        return this._publicImageUrl;
    }

    @Nonnull
    public ImmutableSet<String> getRoles() {
        return this._roles;
    }

    @CheckForNull
    public ProfileAttributes getProfileAttributes() {
        return this._profileAttributes;
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public boolean isVisible() {
        return this._visible;
    }

    @Nonnull
    public ImmutableSet<String> getAllowedActions() {
        return this._allowedActions;
    }

    public boolean isUsesDefaultImage() {
        return this._usesDefaultImage;
    }

    public boolean isAcceptedProfileImageLegalTerms() {
        return this._acceptedProfileImageLegalTerms;
    }

    @CheckForNull
    public Birthday getBirthday() {
        return this._birthday;
    }

    @CheckForNull
    public BirthdayVisibility getBirthdayVisibility() {
        return this._birthdayVisibility;
    }

    @CheckForNull
    public TimeZone getTimezone() {
        return this._timezone;
    }

    @CheckForNull
    public String getGMTTimezone() {
        return this._timezone != null ? this._timezone.getGMTString(new Date()) : null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObjects());
    }

    @Nonnull
    private Object[] hashObjects() {
        return new Object[]{this._id, this._fullname, this._title, this._firstname, this._lastname, this._additionalTitle, this._publicImageUrl, this._roles, this._active, this._blocked, this._deleted, this._visible, this._allowedActions, this._profileAttributes, this._usesDefaultImage, this._timezone, this._birthday, this._birthdayVisibility, this._acceptedProfileImageLegalTerms};
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Profile && Arrays.equals(this.hashObjects(), ((Profile)obj).hashObjects());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this._id).add("fullname", (Object)this._fullname).add("title", (Object)this._title).add("firstname", (Object)this._firstname).add("lastname", (Object)this._lastname).add("additionalTitle", (Object)this._additionalTitle).add("publicImageUrl", (Object)this._publicImageUrl).add("roles", this._roles.size()).add("active", this._active).add("blocked", this._blocked).add("deleted", this._deleted).add("_visible", this._visible).add("allowedActions", this._allowedActions.size()).add("profileAttributes", (Object)this._profileAttributes).add("usesDefaultImage", this._usesDefaultImage).add("acceptedProfileImageLegalTerms", this._acceptedProfileImageLegalTerms).toString();
    }
}

