/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.profile.api.controller.support;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.profile.model.ProfileValidationErrorMessage;
import de.justsoftware.onx.profile.model.ProfileValidationException;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.profile.api.exception.ResourceNotFoundException;
import de.justsoftware.profile.api.model.ErrorResponse;
import de.justsoftware.profile.api.model.ErrorResponseType;
import de.justsoftware.profile.api.model.ValidationErrorMessage;
import de.justsoftware.profile.api.model.ValidationErrorResponse;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackages={"de.justsoftware.profile.api"})
@ParametersAreNonnullByDefault
public class ProfileExceptionHandlingControllerAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileExceptionHandlingControllerAdvice.class);

    @ExceptionHandler(value={PermissionDeniedException.class})
    @Nonnull
    public ResponseEntity<ErrorResponse> handlePermissionDeniedException(PermissionDeniedException e) {
        LOG.debug("permission denied", (Throwable)e);
        return this.createGeneralErrorResponseForException((Throwable)e, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={NotLoggedInException.class})
    @Nonnull
    public ResponseEntity<ErrorResponse> handleNotLoggedInException(NotLoggedInException e) {
        LOG.debug("unauthorized", (Throwable)e);
        return this.createGeneralErrorResponseForException((Throwable)e, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @Nonnull
    public ResponseEntity<ErrorResponse> handleResourceNotFoundException(ResourceNotFoundException e) {
        LOG.debug("resource not found", (Throwable)e);
        return this.createGeneralErrorResponseForException(e, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @Nonnull
    public ResponseEntity<ErrorResponse> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        LOG.debug("invalid http message", (Throwable)e);
        return this.createGeneralErrorResponseForException((Throwable)e, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ProfileValidationException.class})
    @Nonnull
    public ResponseEntity<ValidationErrorResponse> handleProfileValidationException(ProfileValidationException e) {
        LOG.debug("Profile validation errors occurred");
        ImmutableListMultimap validationErrors = ImmutableListMultimap.copyOf((Multimap)Multimaps.transformValues((ListMultimap)e.getValidationErrors(), (Function)new NullPermeableFunction<ProfileValidationErrorMessage, ValidationErrorMessage>(){

            protected ValidationErrorMessage applySafe(ProfileValidationErrorMessage m) {
                return new ValidationErrorMessage(m.getCode().getCode(), m.getMessage(), (ImmutableMap<String, String>)m.getData());
            }
        }));
        return new ResponseEntity((Object)new ValidationErrorResponse((ImmutableListMultimap<String, ValidationErrorMessage>)validationErrors), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ResponseEntity<ErrorResponse> handleThrowable(Throwable t) {
        LOG.error("some unexpected error happened: ", t);
        return this.createGeneralErrorResponseForException(t, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Nonnull
    private ResponseEntity<ErrorResponse> createGeneralErrorResponseForException(Throwable t, HttpStatus status) {
        ErrorResponse errorResponse = new ErrorResponse(ErrorResponseType.GENERAL, t.getClass().getSimpleName() + ": " + t.getMessage());
        return new ResponseEntity((Object)errorResponse, status);
    }
}

