/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.profile.migration.api.controller;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.migration.business.PersonDataImportService;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.business.model.PersonMembershipData;
import de.justsoftware.onx.migration.business.model.PersonSubscriptionData;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.profile.migration.api.exception.IllegalArgumentApiException;
import de.justsoftware.profile.migration.api.model.ProfileImportModel;
import de.justsoftware.profile.migration.api.model.ProfileImportResult;
import de.justsoftware.profile.migration.api.model.ProfileMembershipImportModel;
import de.justsoftware.profile.migration.api.model.ProfileSubscriptionImportModel;
import de.justsoftware.profile.migration.api.model.SingleProfileImportModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/profile-migration/api/v1/import"})
public class ProfileImportController {
    private final PersonDataImportService _personDataImportService;

    @Autowired
    public ProfileImportController(PersonDataImportService personDataImportService) {
        this._personDataImportService = personDataImportService;
    }

    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @Nonnull
    @ApiOperation(value="import a single profile", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns profile data"), @ApiResponse(code=404, message="error - profile not found"), @ApiResponse(code=400, message="error - invalid id"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ProfileImportResult importProfile(@RequestBody SingleProfileImportModel importModel, @AuthorizedContext AuthorizationCheckContext authorizationContext) {
        ProfileImportModel profile = importModel.getProfile();
        String externalId = profile.getExternalId();
        if (Strings.isNullOrEmpty((String)externalId)) {
            throw new IllegalArgumentApiException("No external ID provided");
        }
        Map staticAttributes = (Map)MoreObjects.firstNonNull(profile.getBaseAttributes(), (Object)ImmutableMap.of());
        List<String> rolesList = profile.getRoles();
        ImmutableSet roles = rolesList != null ? ImmutableSet.copyOf(rolesList) : ImmutableSet.of();
        ListMultimap<String, String> dynamicAttributes = this.createDynamicAttributesMap(profile.getProfileAttributes());
        List<PersonSubscriptionData> subscriptionData = this.createSubscriptionModels(importModel.getSubscriptions());
        List<PersonMembershipData> membershipData = this.createMembershipModels(importModel.getMemberships());
        List<UserGroupId> addedUserGroups = this.toUserGroupIds(importModel.getAddedUserGroupMemberships());
        List<UserGroupId> removedUserGroups = this.toUserGroupIds(importModel.getRemovedUserGroupMemberships());
        ImportStatistics statistics = this._personDataImportService.importPerson(externalId, staticAttributes, dynamicAttributes, roles, importModel.getReplaceExistingRoles(), importModel.getTermsAccepted(), importModel.getSendMailToNewUser(), importModel.getActivateNewUser(), importModel.getReimportDeletedUser(), importModel.getImportMode(), profile.getBlockUser(), subscriptionData, membershipData, addedUserGroups, removedUserGroups, authorizationContext);
        return this.createProfileImportResult(statistics, externalId);
    }

    @Nonnull
    private ProfileImportResult.ProfileImportResultType convertToResultType(ImportStatistics statistics) {
        if (statistics.getInsertCount() > 0) {
            return ProfileImportResult.ProfileImportResultType.INSERTED;
        }
        if (statistics.getUpdateCount() > 0) {
            return ProfileImportResult.ProfileImportResultType.UPDATED;
        }
        if (statistics.getSkippedCount() > 0) {
            return ProfileImportResult.ProfileImportResultType.SKIPPED;
        }
        return ProfileImportResult.ProfileImportResultType.ERROR;
    }

    @Nonnull
    private ProfileImportResult.ProfileImportErrorType convertToErrorType(ImportStatistics statistics, String externalId) {
        ImmutableListMultimap importErrors = statistics.getErrors();
        MutableImportErrorType mutableErrorType = new MutableImportErrorType();
        importErrors.forEach((errorType, errorExternalId) -> {
            if (Objects.equals(errorExternalId, externalId)) {
                mutableErrorType.setErrorType((ImportStatistics.ImportErrorType)errorType);
            }
        });
        return mutableErrorType.getErrorType();
    }

    @Nonnull
    private ProfileImportResult createProfileImportResult(ImportStatistics statistics, String externalId) {
        ProfileImportResult.ProfileImportResultType resultType = this.convertToResultType(statistics);
        if (resultType == ProfileImportResult.ProfileImportResultType.INSERTED || resultType == ProfileImportResult.ProfileImportResultType.UPDATED) {
            return new ProfileImportResult(resultType, null);
        }
        ProfileImportResult.ProfileImportErrorType errorType = this.convertToErrorType(statistics, externalId);
        return new ProfileImportResult(resultType, errorType);
    }

    @Nonnull
    private ListMultimap<String, String> createDynamicAttributesMap(@Nullable Map<String, Object> dynamicAttributes) {
        ArrayListMultimap results = ArrayListMultimap.create();
        if (dynamicAttributes == null || dynamicAttributes.isEmpty()) {
            return results;
        }
        dynamicAttributes.forEach((arg_0, arg_1) -> ProfileImportController.lambda$createDynamicAttributesMap$2((ListMultimap)results, arg_0, arg_1));
        return results;
    }

    @Nonnull
    private List<PersonSubscriptionData> createSubscriptionModels(@Nullable List<ProfileSubscriptionImportModel> subscriptions) {
        if (subscriptions == null || subscriptions.isEmpty()) {
            return new ArrayList<PersonSubscriptionData>();
        }
        return subscriptions.stream().map(subscription -> {
            List<Long> defaultEntityIds = subscription.getDefaultEntityIds();
            if (defaultEntityIds == null || defaultEntityIds.isEmpty()) {
                throw new IllegalArgumentApiException("No default Entity Ids provided");
            }
            ArrayList entityTypes = subscription.getFilterByEntityTypes();
            return new PersonSubscriptionData(subscription.getSubscriptionType(), subscription.getExclusive(), defaultEntityIds, (List)(entityTypes == null ? new ArrayList() : entityTypes));
        }).collect(Collectors.toList());
    }

    @Nonnull
    private List<PersonMembershipData> createMembershipModels(@Nullable List<ProfileMembershipImportModel> memberships) {
        if (memberships == null || memberships.isEmpty()) {
            return new ArrayList<PersonMembershipData>();
        }
        return memberships.stream().map(membership -> {
            List<Long> defaultEntityIds = membership.getDefaultEntityIds();
            if (defaultEntityIds == null || defaultEntityIds.isEmpty()) {
                throw new IllegalArgumentApiException("No default Entity Ids provided");
            }
            ArrayList entityTypes = membership.getReplaceMembershipsForEntityTypes();
            return new PersonMembershipData(defaultEntityIds, (List)(entityTypes == null ? new ArrayList() : entityTypes));
        }).collect(Collectors.toList());
    }

    @Nonnull
    private List<UserGroupId> toUserGroupIds(@Nullable List<String> uuids) {
        List nonnullList = (List)MoreObjects.firstNonNull(uuids, (Object)ImmutableList.of());
        return nonnullList.stream().map(UserGroupId::fromString).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$createDynamicAttributesMap$2(ListMultimap results, String attributeName, Object attributeValues) {
        if (attributeValues == null || attributeValues instanceof String) {
            results.put((Object)attributeName, (Object)((String)attributeValues));
        } else if (attributeValues instanceof List) {
            ((List)attributeValues).forEach(attributeValue -> {
                if (!(attributeValue instanceof String)) {
                    throw new IllegalArgumentApiException("unexpected value of type " + attributeValue.getClass());
                }
                results.put((Object)attributeName, (Object)((String)attributeValue));
            });
        } else {
            throw new IllegalArgumentApiException("unexpected value of type " + attributeValues.getClass());
        }
    }

    private static final class MutableImportErrorType {
        private ProfileImportResult.ProfileImportErrorType _errorType = ProfileImportResult.ProfileImportErrorType.UNKNOWN;

        private MutableImportErrorType() {
        }

        @Nonnull
        public ProfileImportResult.ProfileImportErrorType getErrorType() {
            return this._errorType;
        }

        public void setErrorType(@Nullable ImportStatistics.ImportErrorType errorType) {
            if (errorType == null) {
                this._errorType = ProfileImportResult.ProfileImportErrorType.UNKNOWN;
                return;
            }
            switch (errorType) {
                case MISSING_EXTERNAL_ID: {
                    this._errorType = ProfileImportResult.ProfileImportErrorType.MISSING_EXTERNAL_ID;
                    break;
                }
                case MISSING_EMAIL: {
                    this._errorType = ProfileImportResult.ProfileImportErrorType.MISSING_EMAIL;
                    break;
                }
                case MISSING_FIRSTNAME: {
                    this._errorType = ProfileImportResult.ProfileImportErrorType.MISSING_FIRSTNAME;
                    break;
                }
                case MISSING_LASTNAME: {
                    this._errorType = ProfileImportResult.ProfileImportErrorType.MISSING_LASTNAME;
                    break;
                }
                case INVALID_INTERNAL_ID: {
                    this._errorType = ProfileImportResult.ProfileImportErrorType.INVALID_INTERNAL_ID;
                    break;
                }
                case EXCEPTION: {
                    this._errorType = ProfileImportResult.ProfileImportErrorType.EXCEPTION;
                    break;
                }
                case DELETED_IN_JUST: {
                    this._errorType = ProfileImportResult.ProfileImportErrorType.DELETED_IN_JUST;
                }
            }
        }
    }
}

