--liquibase formatted sql

--changeset bjrke:add_timestamps dbms:postgresql runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION update_mtime()
RETURNS TRIGGER AS $$
BEGIN
   NEW.mtime = clock_timestamp();
   RETURN NEW;
END;
$$ language 'plpgsql';

CREATE OR REPLACE FUNCTION ctime_mtime_columns(tname TEXT)
RETURNS VOID AS $$
BEGIN
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN ctime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN mtime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW EXECUTE PROCEDURE update_mtime();';
END;
$$ language 'plpgsql';

--changeset bjrke:add_now_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION now
    RETURN DATE
AS
BEGIN
    RETURN SYSDATE;
END now;

--changeset bjrke:add_clock_timestamp_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION clock_timestamp
    RETURN TIMESTAMP WITH TIME ZONE
AS
BEGIN
    RETURN SYSTIMESTAMP;
END clock_timestamp;

--changeset bjrke:add_timestamps dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE PROCEDURE ctime_mtime_columns(tname VARCHAR2)
IS
BEGIN
    EXECUTE IMMEDIATE 'ALTER TABLE ' || tname || ' ADD (ctime TIMESTAMP DEFAULT SYSDATE NOT NULL,mtime TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL )';
    EXECUTE IMMEDIATE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW BEGIN :new.mtime := SYSTIMESTAMP; END;';
END ctime_mtime_columns;

--changeset mdoelle:create_user_group_table
CREATE TABLE user_group (
    id ${uuid} NOT NULL PRIMARY KEY,
    tenant_id ${uuid} NOT NULL,
    name ${varchar255} NOT NULL
);
${execute} ctime_mtime_columns('user_group');

--changeset wginolas:group_name_unique_constraint
ALTER TABLE user_group ADD CONSTRAINT user_group_name_unique UNIQUE(tenant_id, name);

--changeset wginolas:create_user_group_members_table
CREATE TABLE user_group_member (
    user_group_id ${uuid} NOT NULL,
    profile_id ${int64} NOT NULL,
    PRIMARY KEY(user_group_id, profile_id)
);
${execute} ctime_mtime_columns('user_group_member');

--changeset jschmidt:create_index_for_profile_id
CREATE INDEX user_group_profile_id_idx ON user_group_member(profile_id, user_group_id);

--changeset jschmidt:add_creator_for_user_group
DELETE FROM user_group_member;
DELETE FROM user_group;
ALTER TABLE user_group ADD creator_id ${int64} NOT NULL;
ALTER TABLE user_group_member ADD CONSTRAINT user_group_member_fk FOREIGN KEY (user_group_id) REFERENCES user_group(id);

--changeset jschmidt:no_group_name_unique_constraint
ALTER TABLE user_group DROP CONSTRAINT user_group_name_unique;

--changeset jschmidt:create_table_for_user_group_permissions
CREATE TABLE user_group_permissions (
    user_group_id ${uuid} NOT NULL,
    role ${varchar64} NOT NULL,
    permission ${varchar64} NOT NULL
);
${execute} ctime_mtime_columns('user_group_permissions');

--changeset jschmidt:create_index_for_user_group_id
ALTER TABLE user_group_permissions ADD CONSTRAINT user_group_id_role UNIQUE(user_group_id, role);
ALTER TABLE user_group_permissions ADD CONSTRAINT user_group_permissions_fk FOREIGN KEY (user_group_id) REFERENCES user_group(id);


--changeset jschmit:rename_permissions_to_user_group_roles
ALTER TABLE user_group_permissions RENAME TO user_group_roles;
ALTER TABLE user_group_roles RENAME COLUMN permission TO user_group_role;

--changeset jschmidt:migrate_user_group_permissions
INSERT INTO user_group_roles (user_group_id, role, user_group_role) select id, 'TENANT,'||tenant_id, 'READER' FROM user_group;
INSERT INTO user_group_roles (user_group_id, role, user_group_role) select id, 'USER_GROUP,'||id, 'MANAGER' FROM user_group;


--changeset jschmidt:user_group_creator_nullable dbms:postgresql
ALTER TABLE user_group ALTER COLUMN creator_id DROP NOT NULL;

--changeset jschmidt:user_group_creator_nullable dbms:oracle
ALTER TABLE user_group MODIFY creator_id NULL;

--changeset cewers:delete_permissions_on_group_delete
ALTER TABLE user_group_roles DROP CONSTRAINT user_group_permissions_fk;
ALTER TABLE user_group_roles ADD CONSTRAINT user_group_roles_fk FOREIGN KEY (user_group_id) REFERENCES user_group(id) ON DELETE CASCADE;

--changeset mdoelle:add_all_users_flag_to_group
ALTER TABLE user_group ADD all_tenant_users ${bool} DEFAULT 'f' NOT NULL;

--changeset dwaller:create_external_link_table
CREATE TABLE external_link (
    id ${uuid} PRIMARY KEY,
    uri ${text} NOT NULL,
    tenant_id ${uuid} NOT NULL,
    creator_id ${varchar64} NOT NULL,
    description ${text}
);
${execute} ctime_mtime_columns('external_link');

--changeset dwaller:create_index_for_tenant_id
CREATE INDEX external_link_tenant_id_idx ON external_link(tenant_id);

--changeset jschmidt:add_imported_flag_for_user_groups
ALTER TABLE user_group ADD imported ${bool} DEFAULT 'f' NOT NULL;
UPDATE user_group SET imported = 't' WHERE creator_id IS NULL AND all_tenant_users = 'f';

--changeset cewers:clear_all_tenant_users_group_name
UPDATE user_group set name=' ' WHERE all_tenant_users = 't'; -- oracle does not allow the empty string in on null columns

--changeset vinh.phu.phan:remove_deleted_user_groups_from_user_group_roles
DELETE from user_group_roles WHERE role like 'USER_GROUP,%' AND role NOT IN (SELECT 'USER_GROUP,' || id from user_group);
