/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.kafka.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class KafkaTopicCleanupService
implements InitializingBean {
    public static final int LISTING_TIMEOUT = 10;
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTopicCleanupService.class);
    private static final List<String> TOPICS_TO_CLEANUP = List.of("just.people.profileprocessor-", "just.people.groups", "just.people.groups.members");
    @Autowired
    public KafkaAdmin _admin;
    private final String _bootstrapServers;

    public KafkaTopicCleanupService(@Value(value="${kafka.bootstrapServers}") String bootstrapServers) {
        this._bootstrapServers = bootstrapServers;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    public void afterPropertiesSet() {
        Map<String, String> config = Map.of("bootstrap.servers", this._bootstrapServers);
        try (AdminClient adminClient = KafkaAdminClient.create(config);){
            ListTopicsResult result = adminClient.listTopics();
            List<String> topicsToDelete = ((Collection)result.listings().get(10L, TimeUnit.SECONDS)).stream().map(TopicListing::name).map(s -> s.toLowerCase(Locale.ENGLISH)).filter(s -> TOPICS_TO_CLEANUP.stream().anyMatch(s::startsWith)).collect(Collectors.toList());
            if (!topicsToDelete.isEmpty()) {
                LOG.info("Will delete the following old topics:");
                topicsToDelete.forEach(arg_0 -> ((Logger)LOG).info(arg_0));
                adminClient.deleteTopics(topicsToDelete);
                LOG.info("Topics deleted successfully");
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Error when trying to delete old topics", (Throwable)e);
        }
    }
}

