/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.usergroup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.people.domain.impl.usergroup.UserGroupMapper;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupBO;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupRole;
import de.justsoftware.people.domain.transaction.TransactionSupport;
import de.justsoftware.people.domain.usergroup.UserGroupRepository;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class UserGroupRepositoryImpl
implements UserGroupRepository {
    private final UserGroupMapper _mapper;
    private final DAOSupport _daoSupport;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public UserGroupRepositoryImpl(UserGroupMapper mapper, DAOSupport daoSupport, TransactionSupport transactionSupport) {
        this._mapper = mapper;
        this._daoSupport = daoSupport;
        this._transactionSupport = transactionSupport;
    }

    public UserGroupBO getUserGroup(UserGroupId userGroupId) {
        return (UserGroupBO)this.getUserGroups((Set)ImmutableSet.of((Object)userGroupId)).get((Object)userGroupId);
    }

    public UserGroupId createImportedUserGroup(UserGroupId userGroupId, String name, TenantId tenantId) {
        this._mapper.createUserGroup(userGroupId, null, name, tenantId, true);
        return userGroupId;
    }

    public UserGroupId createUserGroup(String name, ProfileId creator, TenantId tenantId) {
        UserGroupId userGroupId = new UserGroupId(UUID.randomUUID());
        this._mapper.createUserGroup(userGroupId, creator, name, tenantId, false);
        return userGroupId;
    }

    public synchronized UserGroupId createTenantUserGroup(String name, TenantId tenantId) {
        UserGroupId userGroupId = new UserGroupId(UUID.randomUUID());
        this._mapper.createAllTenantUsersGroup(userGroupId, name, tenantId);
        return this._mapper.getTenantUserGroup(tenantId);
    }

    public void addMembersToGroup(UserGroupId userGroupId, Set<ProfileId> members) {
        for (ProfileId m : members) {
            this._mapper.addMemberToGroup(userGroupId, m);
        }
    }

    public void removeMembersFromGroup(UserGroupId userGroupId, Set<ProfileId> members) {
        for (ProfileId m : members) {
            this._mapper.removeMemberFromGroup(userGroupId, m);
        }
    }

    public Set<ProfileId> getMembersOfGroup(UserGroupId userGroupId) {
        return this._mapper.getMembersOfGroup(userGroupId);
    }

    public ImmutableSetMultimap<ProfileId, UserGroupId> getUserGroupsForProfiles(Set<ProfileId> profileIds) {
        return this._daoSupport.partition(profileIds).asSetMultimap((arg_0, arg_1) -> ((UserGroupMapper)this._mapper).getUserGroupsForProfiles(arg_0, arg_1));
    }

    public int forAllUserGroups(Consumer<UserGroupBO> userGroupConsumer) {
        return this._daoSupport.forAll(userGroupConsumer, arg_0 -> ((UserGroupMapper)this._mapper).forAllUserGroups(arg_0));
    }

    public int forAllUserGroupMemberships(BiConsumer<UserGroupId, ProfileId> membershipConsumer) {
        return this._daoSupport.forAll(membership -> membershipConsumer.accept(membership.getUserGroupId(), membership.getProfileId()), arg_0 -> ((UserGroupMapper)this._mapper).forAllUserGroupMemberships(arg_0));
    }

    public void deleteUserGroup(UserGroupId groupId) {
        this._mapper.deleteUserGroup(groupId);
    }

    public void renameUserGroup(UserGroupId groupId, String name) {
        this._mapper.renameUserGroup(groupId, name);
    }

    public ImmutableSet<UserGroupId> checkUserGroupsForProfile(ProfileId id, Set<TenantId> tenantIds) {
        if (tenantIds.isEmpty()) {
            return this._daoSupport.partition((Set)ImmutableSet.of((Object)id)).asSetMultimap((arg_0, arg_1) -> ((UserGroupMapper)this._mapper).getUserGroupsForProfiles(arg_0, arg_1)).get((Object)id);
        }
        return ImmutableSet.copyOf((Collection)this._mapper.getUserGroupsToRemoveForProfile(id, tenantIds));
    }

    public ImmutableTable<UserGroupId, Role, UserGroupRole> getUserGroupRoles(ImmutableSet<UserGroupId> userGroupIds) {
        return this._daoSupport.partition(userGroupIds).asTable((arg_0, arg_1) -> ((UserGroupMapper)this._mapper).getUserGroupRoles(arg_0, arg_1));
    }

    public void setUserGroupRoles(UserGroupId groupId, Map<Role, UserGroupRole> userGroupRoles) {
        this._transactionSupport.doInTransaction(() -> {
            this._mapper.deleteUserGroupRoles(groupId);
            userGroupRoles.forEach((role, userGroupRole) -> this._mapper.setUserGroupRoles(groupId, role, userGroupRole));
        });
    }

    public ImmutableSet<UserGroupId> getUserGroupIdsWithPermissionRole(Role role) {
        return ImmutableSet.copyOf((Collection)this._mapper.getUserGroupIdsWithPermissionRole(role));
    }

    public ImmutableMap<UserGroupId, UserGroupBO> getUserGroups(Set<UserGroupId> userGroupIds) {
        return (ImmutableMap)this._daoSupport.partition(userGroupIds).index(UserGroupBO::getId).asMap().query((arg_0, arg_1) -> ((UserGroupMapper)this._mapper).getUserGroups(arg_0, arg_1));
    }

    public void updateUserGroup(UserGroupId userGroupId, String name, TenantId tenantId) {
        this._mapper.updateUserGroup(userGroupId, name, tenantId);
    }

    public UserGroupId getAllTenantUsersGroupId(TenantId tenantId) {
        return this._mapper.getTenantUserGroup(tenantId);
    }

    public void migrateTenantRole(Role tenantRole, Role allUsersRole) {
        this._transactionSupport.doInTransaction(() -> {
            this._mapper.migrateTenantRole(tenantRole, allUsersRole);
            this._mapper.deleteAllTenantRoles(tenantRole);
        });
    }

    public ImmutableSet<TenantId> getTenantIdsFromRole() {
        return (ImmutableSet)this._mapper.getAllTenantRoles().stream().map(TenantId::fromRole).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }
}

