/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.search;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.model.DynamicAttributeSearchableField;
import de.justsoftware.people.business.search.model.SearchableField;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchableFieldToSolrFilterFieldVisitor
implements SearchableField.SearchableFieldVisitor<String> {
    private final ImmutableMap<String, ProfileAttributeConfig> _configurations;

    public SearchableFieldToSolrFilterFieldVisitor(ImmutableMap<String, ProfileAttributeConfig> configurations) {
        this._configurations = configurations;
    }

    public String visitFirstName() {
        return "firstName";
    }

    public String visitLastName() {
        return "lastName";
    }

    public String visitTitle() {
        return "title";
    }

    public String visitAdditionalTitle() {
        return "additionalTitle";
    }

    public String visitDynamicAttribute(DynamicAttributeSearchableField field) {
        String attributeName = field.getAttributeName();
        ProfileAttributeConfig config = (ProfileAttributeConfig)this._configurations.get((Object)attributeName);
        if (config != null && config.isSearchable() && config.isPhoneNumber()) {
            return "profile_phone_number_dynamic_" + attributeName;
        }
        return "profile_dynamic_" + attributeName;
    }
}

