/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.search;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileDynamicAttributeIndexer {
    private final ImmutableMap<String, ProfileAttributeConfig> _attributeConfig;

    ProfileDynamicAttributeIndexer(ImmutableMap<String, ProfileAttributeConfig> attributeConfig) {
        this._attributeConfig = attributeConfig;
    }

    @Nonnull
    ImmutableSetMultimap<String, String> convertForSolrIndex(Map<String, Collection<String>> dynamicAttributeValues) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        dynamicAttributeValues.forEach((fieldName, values) -> {
            ProfileAttributeConfig attributeConfig = (ProfileAttributeConfig)this._attributeConfig.getOrDefault(fieldName, null);
            if (attributeConfig != null && attributeConfig.isSearchable()) {
                result.putAll((Object)("profile_dynamic_" + fieldName), (Iterable)values.stream().filter(Objects::nonNull).flatMap(this.getTranslations(attributeConfig)).collect(ImmutableSet.toImmutableSet()));
            }
            if (attributeConfig != null && attributeConfig.isFacetable()) {
                result.putAll((Object)("profile_facet_dynamic_" + fieldName), (Iterable)values.stream().filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet()));
            }
            if (attributeConfig != null && attributeConfig.isSearchable() && attributeConfig.isPhoneNumber()) {
                result.putAll((Object)("profile_phone_number_dynamic_" + fieldName), (Iterable)values.stream().filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet()));
            }
        });
        return result.build();
    }

    @Nonnull
    private Function<String, Stream<? extends String>> getTranslations(ProfileAttributeConfig attributeConfig) {
        return value -> {
            ImmutableSet translations = attributeConfig.getTranslatedValues().get(value);
            if (translations.isEmpty()) {
                return ImmutableSet.of((Object)value).stream();
            }
            return translations.stream();
        };
    }
}

