/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.externallink;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.domain.externallink.ExternalLinkRepository;
import de.justsoftware.people.domain.impl.externallink.ExternalLinkMapper;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.externallink.ExternalLinkBO;
import de.justsoftware.people.domain.model.externallink.ExternalLinkId;
import de.justsoftware.people.domain.model.externallink.ValidLinkInsertModel;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class ExternalLinkRepositoryImpl
implements ExternalLinkRepository {
    private final ExternalLinkMapper _mapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public ExternalLinkRepositoryImpl(ExternalLinkMapper mapper, DAOSupport daoSupport) {
        this._mapper = mapper;
        this._daoSupport = daoSupport;
    }

    public ExternalLinkId createExternalLink(ValidLinkInsertModel linkInsertModel, TenantId tenantId, ProfileId creator) {
        ExternalLinkId linkId = ExternalLinkId.random();
        this._mapper.createExternalLink(linkId, creator, tenantId, linkInsertModel.getUri(), linkInsertModel.getDescription());
        return linkId;
    }

    @Nonnull
    public ImmutableList<ExternalLinkBO> getAllExternalLinks(TenantId tenantId) {
        return ImmutableList.copyOf((Collection)this._mapper.getAllExternalLinks(tenantId));
    }

    public void deleteLinksById(TenantId tenantId, ImmutableSet<ExternalLinkId> linkIds) {
        this._daoSupport.partition(linkIds).noResult(ids -> this._mapper.deleteLinksById(tenantId, ImmutableSet.copyOf((Collection)ids)));
    }
}

